/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.common.utils.XMLHelper;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.CRDData;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCardProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IMCardManagedBean;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IUserCredentials;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.MCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.UsernamePasswordCredentials;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.managed.MCard;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.MapConfiguraton;
import org.eclipse.higgins.registry.RegistryConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CardProvider
extends ManagedCardProvider
implements ICardProvider,
IConfigurableComponent {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$CardProvider == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$CardProvider = CardProvider.class$("org.eclipse.higgins.icard.provider.cardspace.managed.CardProvider")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$CardProvider));
    private String id = "org.eclipse.higgins.icard.provider.cardspace.managed.db";
    private String name = "CardSpace-compatable managed I-Card Provider Plug-in";
    private IConfiguration config = null;
    private IMCardManagedBean mbean = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$CardProvider;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    private HashMap convertConfigurationToMap(IConfiguration config) {
        HashMap<String, Object> ht = new HashMap<String, Object>();
        Iterator itr = config.getPropertyNames();
        while (itr.hasNext()) {
            String key = itr.next().toString();
            Object value = config.getProperty(key);
            ht.put(key, value);
        }
        return ht;
    }

    protected void init(Map config) throws Exception {
        String managedBeanClassName = (String)config.get("managedbean.classname");
        if (managedBeanClassName == null) {
            throw new CardException("Can not find \"managedbean.classname\" configuration property");
        }
        Class<?> cls = Class.forName(managedBeanClassName);
        super.init(config);
        this.mbean = (IMCardManagedBean)cls.newInstance();
        this.mbean.init(config);
    }

    private synchronized void initFromRegistryConfig() throws CardException {
        if (this.mbean == null) {
            try {
                HashMap configMap = this.convertConfigurationToMap(this.getConfiguration());
                this.init(configMap);
                log.info((Object)("Provider " + this.getID() + " was initialized from registry configuration."));
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new CardException((Throwable)e);
            }
        }
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        log.info((Object)("Initializing provider " + this.getID() + " from higgins configuration as IConfigurableComponent."));
        this.config = new MapConfiguraton(mapComponentSettings);
        this.init(mapComponentSettings);
        log.info((Object)("Provider " + this.getID() + " from higgins configuration as IConfigurableComponent."));
    }

    public ISettingDescriptor getComponentDescriptor() {
        return null;
    }

    public void setID(String id) throws Exception {
        this.id = id;
    }

    public IMCardManagedBean getManagedBean() throws CardException {
        if (this.mbean == null) {
            this.initFromRegistryConfig();
        }
        return this.mbean;
    }

    public Iterator getICards(CallbackHandler authHandler) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        ArrayList<MCard> cards = new ArrayList<MCard>();
        IUserCredentials userCrds = this.authenticate(authHandler);
        List lst = this.getManagedBean().getMCards(userCrds);
        int j = lst.size();
        for (int i = 0; i < j; ++i) {
            MCardEntity crd = (MCardEntity)lst.get(i);
            MCard card = new MCard(this, userCrds, crd);
            cards.add(card);
        }
        return cards.iterator();
    }

    public ICard importCard(CallbackHandler authHandler, String filename) throws CardException {
        FileInputStream fis;
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (filename == null) {
            throw new CardException("Parameter \"filename\" is null");
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        if (filename.toUpperCase().endsWith(".CRDS")) {
            this.importFromCrdsFile(authHandler, fis);
            return null;
        }
        if (filename.toUpperCase().endsWith(".CRD")) {
            return this.importFromCrdFile(authHandler, fis);
        }
        throw new CardException("Unsupported file extension.");
    }

    private ICard importFromCrdFile(CallbackHandler authHandler, InputStream is) throws CardException {
        try {
            Element elm = XMLHelper.domFromStream((InputStream)is);
            CRDData crdData = CardCryptography.getCardFromSignedEnvelop((Element)elm);
            IElement iElm = crdData.getCard();
            Element crd = (Element)iElm.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = CardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            IUserCredentials userCrds = this.authenticate(authHandler);
            MCard mc = new MCard(this, userCrds, crd);
            return mc;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    private void importFromCrdsFile(CallbackHandler authHandler, InputStream is) throws CardException {
        Document cardBackup;
        PasswordCallback pc = new PasswordCallback("Enter password for imported backup file: ", false);
        Callback[] callbacks = new Callback[]{pc};
        try {
            authHandler.handle(callbacks);
            String password = new String(pc.getPassword());
            pc.clearPassword();
            cardBackup = CardCryptography.decrypt((InputStream)is, (String)password);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        ArrayList<MCard> cardsList = new ArrayList<MCard>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        IUserCredentials userCrds = this.authenticate(authHandler);
        int j = newCards.getLength();
        for (int i = 0; i < j; ++i) {
            Node nd = newCards.item(i);
            if (nd.getNodeType() != 1) continue;
            Element elm = (Element)nd;
            try {
                MCard mc = new MCard(this, userCrds, elm);
                cardsList.add(mc);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public void deleteCard(CallbackHandler authHandler, ICard card) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        IUserCredentials userCreds = this.authenticate(authHandler);
        this.getManagedBean().deleteMCard(card.getID(), userCreds);
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean canCreateCard(CallbackHandler authHandler, String id, Properties props) {
        return false;
    }

    public ICard createCard(CallbackHandler authHandler, String id, Properties props) throws CardException {
        throw new CardException("This provider can't create a card.");
    }

    public String getDescription() {
        return "IdAS-based CardSpace-interoperable managed I-Card provider";
    }

    public ICard importICard(CallbackHandler authHandler, IElement element) throws CardException {
        try {
            Element crd = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = CardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            IUserCredentials userCrds = this.authenticate(authHandler);
            MCard mc = new MCard(this, userCrds, crd);
            return mc;
        }
        catch (CardException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
    }

    protected ICard getICardByID(CallbackHandler authHandler, String cardID) throws CardException {
        IUserCredentials userCreds = this.authenticate(authHandler);
        MCardEntity crd = this.getManagedBean().getMCard(cardID, userCreds);
        if (crd != null) {
            return new MCard(this, userCreds, crd);
        }
        return null;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        if (!this.getID().equals(cuid.getProviderID())) {
            log.debug((Object)("ProviderID of requested CUID (" + cuid.getProviderID() + ") is not equal to this providerID (" + this.getID() + ")."));
            return null;
        }
        ICard crd = this.getICardByID(authHandler, cuid.getCardID());
        if (crd == null) {
            log.debug((Object)("Can not find any card with ID = " + cuid.getCardID()));
            return null;
        }
        String issuer = cuid.getIssuer();
        if (issuer != null && issuer.equals(crd.getIssuer())) {
            return crd;
        }
        log.debug((Object)("Wrong issuer for card with ID = " + cuid.getCardID() + ". Requested issuer = " + issuer + ", real issuer = " + crd.getIssuer()));
        return null;
    }

    private IUserCredentials authenticate(CallbackHandler authHandler) throws CardException {
        NameCallback nc = new NameCallback("User id: ");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            authHandler.handle(callbacks);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        String userName = nc.getName();
        if (userName == null || userName.trim().length() == 0) {
            throw new CardException("Empty user name.");
        }
        String pass = pc != null && pc.getPassword() != null ? new String(pc.getPassword()) : "";
        return new UsernamePasswordCredentials(userName, pass);
    }

    public ICard createCard(CallbackHandler authHandler, ICardTemplate template) throws CardException {
        throw new CardException("ICard provider " + this.name + " can not create a card.");
    }

    public IConfiguration getConfiguration() {
        if (this.config == null) {
            this.initConfiguration();
        }
        return this.config;
    }

    public synchronized void initConfiguration() {
        if (this.config == null) {
            try {
                this.config = ICardRegistry.getInstance().getConfiguration((IServiceProvider)this);
            }
            catch (RegistryConfigurationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

