/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardExtensionEvent;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IExtensionListener;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCardExtension;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.STSPrivacyPolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.Extension;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IMCardManagedBean;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.IUserCredentials;
import org.eclipse.higgins.icard.provider.cardspace.common.entity.MCardEntity;
import org.eclipse.higgins.icard.provider.cardspace.managed.CardProvider;
import org.w3c.dom.Element;

public class MCard
extends ManagedCard
implements IExtensionListener {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$MCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$MCard = MCard.class$("org.eclipse.higgins.icard.provider.cardspace.managed.MCard")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$MCard));
    private MCardEntity card_ = null;
    private boolean editMode_ = false;
    IUserCredentials credentials_;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$MCard;
    static /* synthetic */ Class class$java$lang$String;

    public MCard() {
    }

    public MCard(CardProvider provider, IUserCredentials credentials, MCardEntity card) throws CardException {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new IllegalArgumentException("Parameter \"card\" is null");
        }
        this.description_ = "IdAS-based CardSpace-interoperable managed I-Card";
        this.provider_ = provider;
        this.credentials_ = credentials;
        this.card_ = card;
        this.init();
    }

    public MCard(CardProvider provider, IUserCredentials credentials, Element card) throws CardException {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new IllegalArgumentException("Parameter \"card\" is null");
        }
        this.description_ = "IdAS-based CardSpace-interoperable managed I-Card";
        this.provider_ = provider;
        this.credentials_ = credentials;
        this.initFromXML(card);
        this.card_ = new MCardEntity();
        try {
            this.saveCard();
        }
        catch (IOException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        IMCardManagedBean mbean = provider.getManagedBean();
        MCardEntity oldCard = mbean.getMCard(this.id_.toString(), credentials);
        if (oldCard != null) {
            mbean.deleteMCard(oldCard.getCardID().toString(), credentials);
        }
        mbean.persistMCard(this.card_, credentials);
    }

    public void init() throws CardException {
        this.initIsSelfIssued();
        this.initLanguage();
        this.initCardId();
        this.initCardVersion();
        this.initCardName();
        this.initCardImage();
        this.initCardImageType();
        this.initIssuer();
        this.initIssuerID();
        this.initIssuerName();
        this.initTimeIssued();
        this.initTimeExpires();
        this.initSupportedTokenTypes();
        this.initClaimTypes();
        this.initTokenServiceList();
        this.initRequireAppliesTo();
        this.initPrivacyNotice();
        this.initHashSalt();
        this.initTimeLastUpdated();
        this.initMasterKey();
        this.initExtensions();
        this.initStandardExtensionFields();
    }

    private void initIsSelfIssued() {
        this.isSelfIssued_ = false;
    }

    private void initLanguage() {
        this.language_ = this.card_.getLanguage();
    }

    private void initCardId() throws CardException {
        this.id_ = this.card_.getCardID();
    }

    private void initCardVersion() {
        this.version_ = String.valueOf(this.card_.getVersion());
    }

    private void initCardName() {
        this.name_ = this.card_.getName();
    }

    private void initCardImage() {
        this.image_ = this.card_.getImage();
    }

    private void initCardImageType() {
        this.imageMimeType_ = this.card_.getImageType();
    }

    private void initIssuer() {
        this.issuer_ = this.card_.getIssuer() != null ? this.card_.getIssuer().toString() : null;
    }

    private void initIssuerID() {
        this.issuerID_ = this.card_.getIssuerID();
    }

    private void initIssuerName() {
        this.issuerName_ = this.card_.getIssuerName();
    }

    private void initTimeIssued() {
        this.timeIssued_ = this.card_.getTimeIssued();
    }

    private void initTimeExpires() {
        this.timeExpires_ = this.card_.getTimeExpires();
    }

    private void initSupportedTokenTypes() throws CardException {
        this.supportedTokenTypes_ = this.card_.getSupportedTokenTypeList();
    }

    private void initClaimTypes() throws CardException {
        this.claimTypes_ = this.card_.getSupportedClaimTypeList();
    }

    private void initTokenServiceList() throws CardException {
        this.tokenServices_ = this.card_.getTokenServiceList();
    }

    private void initRequireAppliesTo() {
        this.requireAppliesTo_ = this.card_.getRequireAppliesTo();
    }

    private void initPrivacyNotice() throws CardException {
        String version;
        this.privacyNotice_ = null;
        URI uri = this.card_.getPolicyURL();
        String string = version = this.card_.getPolicyVersion() != null ? this.card_.getPolicyVersion().toString() : null;
        if (uri != null) {
            this.privacyNotice_ = new STSPrivacyPolicy(uri.toString(), version);
        }
    }

    private void initHashSalt() {
        this.hashSalt_ = this.card_.getHashSalt();
    }

    private void initTimeLastUpdated() {
        this.timeLastUpdated_ = this.card_.getTimeLastUpdated();
    }

    private void initMasterKey() {
        this.rawMasterKey_ = this.card_.getMasterKey();
    }

    private void initExtensions() throws CardException {
        this.extensions_ = new ArrayList();
        List lst = this.card_.getExtensionList();
        int j = lst.size();
        for (int i = 0; i < j; ++i) {
            Extension ext = (Extension)lst.get(i);
            String elmStr = ext.getExtensionData();
            IOElement elm = new IOElement();
            try {
                elm.set((Object)elmStr);
            }
            catch (Exception e) {
                throw new CardException((Throwable)e);
            }
            boolean enabled = ext.isEnabled();
            InformationCardExtension icExt = new InformationCardExtension((IElement)elm, enabled, (Object)ext);
            icExt.addListener((IExtensionListener)this);
            this.extensions_.add(icExt);
        }
    }

    public void setName(String name) throws CardException {
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        String oldName = this.name_;
        try {
            this.name_ = name != null ? name.trim() : "";
            this.saveCardName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.name_ = oldName;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setImage(byte[] image, String imageMimeType) throws CardException {
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        byte[] oldImage = this.image_;
        String oldImageType = this.imageMimeType_;
        this.image_ = image;
        this.imageMimeType_ = imageMimeType;
        try {
            this.saveCardImage();
            this.saveCardImageType();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.image_ = oldImage;
            this.imageMimeType_ = oldImageType;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setIssuerName(String name) throws CardException {
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card issuer name.");
        }
        String oldName = this.issuerName_;
        try {
            this.issuerName_ = name.trim();
            this.saveIssuerName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.issuerName_ = oldName;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setTimeExpires(java.util.Date date) throws CardException {
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        java.util.Date oldDate_ = this.timeExpires_;
        try {
            this.timeExpires_ = date;
            this.saveTimeExpires();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.timeExpires_ = oldDate_;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private void saveCard() throws CardException, IOException {
        this.saveIsSelfIssued();
        this.saveLanguage();
        this.saveCardId();
        this.saveCardVersion();
        this.saveCardName();
        this.saveCardImage();
        this.saveCardImageType();
        this.saveIssuer();
        this.saveIssuerID();
        this.saveIssuerName();
        this.saveTimeIssued();
        this.saveTimeExpires();
        this.saveSupportedTokenTypes();
        this.saveClaimTypes();
        this.saveTokenServiceList();
        this.saveRequireAppliesTo();
        this.savePrivacyNotice();
        this.saveHashSalt();
        this.saveTimeLastUpdated();
        this.saveMasterKey();
        this.saveExtensions();
    }

    private void saveIsSelfIssued() {
    }

    private void saveLanguage() throws CardException {
        this.card_.setLanguage(this.language_);
    }

    private void saveCardId() throws CardException {
        this.card_.setCardID(this.id_);
    }

    private void saveCardVersion() throws CardException {
        this.card_.setVersion(Integer.parseInt(this.version_));
    }

    private void saveCardName() throws CardException {
        this.card_.setName(this.name_);
    }

    private void saveCardImage() throws CardException {
        this.card_.setImage(this.image_);
    }

    private void saveCardImageType() throws CardException {
        this.card_.setImageType(this.imageMimeType_);
    }

    private void saveIssuer() throws CardException {
        URI uri;
        try {
            uri = this.issuer_ != null ? new URI(this.issuer_) : null;
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardException((Throwable)e);
        }
        this.card_.setIssuer(uri);
    }

    private void saveIssuerID() throws CardException {
        this.card_.setIssuerID(this.issuerID_);
    }

    private void saveIssuerName() throws CardException {
        this.card_.setIssuerName(this.issuerName_);
    }

    private void saveTimeIssued() throws CardException {
        this.card_.setTimeIssued((java.util.Date)new Date(this.timeIssued_.getTime()));
    }

    private void saveTimeExpires() throws CardException {
        Date dt = null;
        if (this.timeExpires_ != null) {
            dt = new Date(this.timeExpires_.getTime());
        }
        this.card_.setTimeExpires(dt);
    }

    private void saveSupportedTokenTypes() throws CardException {
        this.card_.setSupportedTokenTypeList(this.supportedTokenTypes_);
    }

    private void saveClaimTypes() throws CardException {
        this.card_.setSupportedClaimTypeList(this.claimTypes_);
    }

    private void saveTokenServiceList() throws CardException, IOException {
        this.card_.setTokenServiceList(this.tokenServices_);
    }

    private void saveRequireAppliesTo() throws CardException {
        this.card_.setRequireAppliesTo(this.requireAppliesTo_);
    }

    private void savePrivacyNotice() throws CardException, IOException {
        Object val = null;
        if (this.privacyNotice_ != null) {
            String url = this.privacyNotice_.getPrivacyUrl();
            String versionStr = this.privacyNotice_.getPrivacyVersion();
            if (url != null) {
                try {
                    URI uri = new URI(url);
                    this.card_.setPolicyURL(uri);
                    if (versionStr != null) {
                        Integer version = Integer.decode(versionStr);
                        this.card_.setPolicyVersion(version);
                    }
                }
                catch (Exception e) {
                    throw new CardException((Throwable)e);
                }
            }
        }
    }

    private void saveHashSalt() throws CardException {
        this.card_.setHashSalt(this.hashSalt_);
    }

    private void saveTimeLastUpdated() throws CardException {
        this.timeLastUpdated_ = new java.util.Date();
        this.card_.setTimeLastUpdated((java.util.Date)new Date(this.timeLastUpdated_.getTime()));
    }

    private void saveMasterKey() throws CardException {
        this.card_.setMasterKey(this.rawMasterKey_);
    }

    private void saveExtensions() throws CardException {
        ArrayList<Extension> extList = new ArrayList<Extension>();
        int j = this.extensions_.size();
        for (int i = 0; i < j; ++i) {
            IInformationCardExtension extension = (IInformationCardExtension)this.extensions_.get(i);
            Object id = extension.getId();
            if (id != null) continue;
            Extension icExt = new Extension();
            IElement elm = extension.getElement();
            boolean enabled = extension.isEnabled();
            String data = null;
            try {
                data = (String)elm.getAs(class$java$lang$String == null ? MCard.class$("java.lang.String") : class$java$lang$String);
            }
            catch (Exception e) {
                throw new CardException((Throwable)e);
            }
            icExt.setEnabled(enabled);
            icExt.setExtensionData(data);
            extList.add(icExt);
            extension.setId((Object)icExt);
            extension.addListener((IExtensionListener)this);
        }
        this.card_.setExtensionList(extList);
    }

    public void applyUpdates() throws InvalidStateException, CardException {
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        IMCardManagedBean mbean = ((CardProvider)this.provider_).getManagedBean();
        mbean.persistMCard(this.card_, this.credentials_);
        this.editMode_ = false;
    }

    public void beginUpdates() throws InvalidStateException {
        if (this.editMode_) {
            throw new InvalidStateException("Already in edit mode.");
        }
        this.editMode_ = true;
    }

    public void cancelUpdates() throws InvalidStateException {
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        this.editMode_ = false;
    }

    public boolean isEditMode() {
        return this.editMode_;
    }

    public boolean isEditable() {
        return false;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public boolean isClaimsRetrieved() {
        return false;
    }

    public IInformationCardExtension addExtension(IElement extension) throws CardException {
        if (extension == null) {
            throw new CardException("Parameter \"extension\" is null");
        }
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        Extension icExt = new Extension();
        boolean enabled = true;
        String data = null;
        try {
            data = (String)extension.getAs(class$java$lang$String == null ? (class$java$lang$String = MCard.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception e) {
            throw new CardException((Throwable)e);
        }
        icExt.setExtensionData(data);
        icExt.setEnabled(enabled);
        this.card_.getExtensionList().add(icExt);
        InformationCardExtension ext = new InformationCardExtension(extension, enabled, (Object)icExt);
        ext.addListener((IExtensionListener)this);
        this.extensions_.add(ext);
        return ext;
    }

    public void removeExtension(IInformationCardExtension extension) throws CardException {
        Object id;
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (this.extensions_.contains(extension)) {
            id = extension.getId();
            if (!(id instanceof Extension)) {
                throw new CardException("Could not remove extension.");
            }
        } else {
            throw new CardException("Could not remove extension because the card does not contain this extension.");
        }
        this.card_.getExtensionList().remove(id);
        this.extensions_.remove(extension);
    }

    public void extensionElementChanged(ICardExtensionEvent event) throws CardException {
        String newElement;
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        IInformationCardExtension icExt = event.getExtension();
        IElement iElement = icExt.getElement();
        try {
            newElement = (String)iElement.getAs(class$java$lang$String == null ? (class$java$lang$String = MCard.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception e) {
            throw new CardException((Throwable)e);
        }
        Object id = icExt.getId();
        if (id instanceof Extension) {
            Extension ext = (Extension)id;
            String oldElement = ext.getExtensionData();
            if (oldElement == null || !oldElement.equals(newElement)) {
                ext.setExtensionData(newElement);
            }
        } else {
            throw new CardException("IInformationCardExtension.getId() should return an instnace of IDaoInformationCardExtension");
        }
    }

    public void extensionEnabledChanged(ICardExtensionEvent event) throws CardException {
        if (!this.editMode_) {
            throw new InvalidStateException("Not in edit mode.");
        }
        IInformationCardExtension icExt = event.getExtension();
        boolean newEnabled = icExt.isEnabled();
        Object id = icExt.getId();
        if (id instanceof Extension) {
            Extension ext = (Extension)id;
            boolean oldEnabled = ext.isEnabled();
            if (newEnabled != oldEnabled) {
                ext.setEnabled(newEnabled);
            }
        } else {
            throw new CardException("IInformationCardExtension.getId() should return an instnace of IDaoInformationCardExtension");
        }
    }

    public byte[] getMasterKey() throws CardException {
        return this.rawMasterKey_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

