/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.managed;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.utils.DateConvertor;
import org.eclipse.higgins.icard.common.utils.IdASContext;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.CredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.EndpointReference;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.STSPrivacyPolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.TokenService;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.eclipse.higgins.icard.provider.cardspace.managed.IdASBasedManagedCardProvider;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class IdASBasedManagedCard
extends ManagedCard {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCard = IdASBasedManagedCard.class$("org.eclipse.higgins.icard.provider.cardspace.managed.IdASBasedManagedCard")) : class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCard));
    IEntity card_ = null;
    private boolean editMode = false;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$managed$IdASBasedManagedCard;
    static /* synthetic */ Class class$java$lang$String;

    public IdASBasedManagedCard() {
    }

    public IdASBasedManagedCard(IdASBasedManagedCardProvider provider, IEntity card) throws Exception {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new IllegalArgumentException("Parameter \"card\" is null");
        }
        this.description_ = "IdAS-based CardSpace-interoperable managed I-Card";
        this.provider_ = provider;
        this.card_ = card;
        this.initFromDS(this.card_);
    }

    public IdASBasedManagedCard(IdASBasedManagedCardProvider provider, IContext context, Element card) throws Exception {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new IllegalArgumentException("Parameter \"card\" is null");
        }
        this.description_ = "IdAS-based CardSpace-interoperable managed I-Card";
        this.provider_ = provider;
        this.initFromXML(card);
        try {
            try {
                this.card_ = context.getEntity(this.id_.toString());
            }
            catch (NoSuchEntityException e) {
                this.card_ = context.addEntity(IdASContext.ICARD_ManagedInformationCard, this.id_.toString());
            }
            this.saveCard();
            context.applyUpdates();
        }
        catch (Exception e) {
            try {
                context.cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
            }
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public void initFromDS(IEntity card) throws Exception {
        this.initIsSelfIssued(card);
        this.initLanguage(card);
        this.initCardId(card);
        this.initCardVersion(card);
        this.initCardName(card);
        this.initCardImage(card);
        this.initCardImageType(card);
        this.initIssuer(card);
        this.initIssuerName(card);
        this.initTimeIssued(card);
        this.initTimeExpires(card);
        this.initSupportedTokenTypes(card);
        this.initClaimTypes(card);
        this.initTokenServiceList(card);
        this.initRequireAppliesTo(card);
        this.initPrivacyNotice(card);
        this.initHashSalt(card);
        this.initTimeLastUpdated(card);
        this.initMasterKey(card);
    }

    private void initIsSelfIssued(IEntity card) throws IdASException, CardException, ClassCastException {
        this.isSelfIssued_ = false;
        Boolean issi = (Boolean)this.getSimpleValueData(card, IdASContext.ICARD_isSelfIssued);
        if (issi != null && issi.booleanValue()) {
            throw new CardException("Can not init managed card with Entity storing data of self-issued (Personal) card");
        }
    }

    private void initLanguage(IEntity card) throws IdASException, CardException, ClassCastException {
        this.language_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_language);
    }

    private void initCardId(IEntity card) throws IdASException, CardException, ClassCastException {
        String id = (String)this.getSimpleValueData(card, IdASContext.HIGGINS_uniqueIdentifier);
        try {
            this.id_ = new URI(id);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private void initCardVersion(IEntity card) throws IdASException, CardException, ClassCastException {
        this.version_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_version);
    }

    private void initCardName(IEntity card) throws IdASException, CardException, ClassCastException {
        this.name_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_name);
    }

    private void initCardImage(IEntity card) throws IdASException, CardException, ClassCastException {
        this.image_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_image);
    }

    private void initCardImageType(IEntity card) throws IdASException, CardException, ClassCastException {
        this.imageMimeType_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_imageMimeType);
    }

    private void initIssuer(IEntity card) throws IdASException, CardException, ClassCastException {
        this.issuer_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_issuer);
    }

    private void initIssuerName(IEntity card) throws IdASException, CardException, ClassCastException {
        this.issuerName_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_issuerName);
    }

    private void initTimeIssued(IEntity card) throws IdASException, CardException {
        this.timeIssued_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeIssued);
        if (obj != null) {
            this.timeIssued_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initTimeExpires(IEntity card) throws IdASException, CardException {
        this.timeExpires_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_expiredTime);
        if (obj != null) {
            this.timeExpires_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initSupportedTokenTypes(IEntity card) throws IdASException, CardException {
        this.supportedTokenTypes_ = new ArrayList();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IAttributeValue val = (IAttributeValue)itr.next();
            if (val.isSimple()) {
                Object obj;
                ISimpleAttrValue sv = (ISimpleAttrValue)val;
                if (sv == null || (obj = sv.getData()) == null) continue;
                if (obj instanceof URI) {
                    this.supportedTokenTypes_.add(obj);
                    continue;
                }
                try {
                    this.supportedTokenTypes_.add(new URI(obj.toString()));
                    continue;
                }
                catch (URISyntaxException e) {
                    this.log.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
            throw new CardException("Attribute " + IdASContext.ICARD_supportedTokenType + " contains non simple value");
        }
    }

    private void initClaimTypes(IEntity card) throws IdASException, CardException {
        this.claimTypes_ = new ArrayList();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_supportedClaimType);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IComplexAttrValue cv;
            IAttributeValue val = (IAttributeValue)itr.next();
            if (val.isSimple() || (cv = (IComplexAttrValue)val) == null) continue;
            URI type = (URI)this.getSimpleValueData(cv, IdASContext.ICARD_claimTypeType);
            String typeStr = type != null ? type.toString() : "";
            String name = (String)this.getSimpleValueData(cv, IdASContext.ICARD_claimTypeName);
            String description = (String)this.getSimpleValueData(cv, IdASContext.ICARD_claimTypeDescription);
            boolean isPPID = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(typeStr);
            ClaimType ct = new ClaimType(typeStr, name, description, !isPPID, !isPPID);
            this.claimTypes_.add(ct);
        }
    }

    private void initTokenServiceList(IEntity card) throws ClassCastException, IdASException, CardException, IllegalArgumentException, ParserConfigurationException, SAXException, IOException {
        this.tokenServices_ = new ArrayList();
        IAttribute attr = card.getAttribute(IdASContext.ICARD_tokenService);
        Iterator itr = attr.getValues();
        while (itr.hasNext()) {
            IAttributeValue val = (IAttributeValue)itr.next();
            if (val.isSimple()) continue;
            IComplexAttrValue cv = (IComplexAttrValue)val;
            URI epAddress = (URI)this.getSimpleValueData(cv, IdASContext.ICARD_endpoint_address);
            String epMetadata = (String)this.getSimpleValueData(cv, IdASContext.ICARD_endpoint_metadata);
            String epIdentity = (String)this.getSimpleValueData(cv, IdASContext.ICARD_endpoint_identity);
            String ucHint = (String)this.getSimpleValueData(cv, IdASContext.ICARD_credential_displayCredentialHint);
            String ucCredential = (String)this.getSimpleValueData(cv, IdASContext.ICARD_credential_credential);
            EndpointReference endpoint = new EndpointReference(epAddress, epMetadata, epIdentity);
            CredentialDescriptor credential = new CredentialDescriptor(ucHint, ucCredential);
            TokenService tc = new TokenService(endpoint, credential);
            this.tokenServices_.add(tc);
        }
    }

    private void initRequireAppliesTo(IEntity card) throws IdASException, CardException {
        this.requireAppliesTo_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_requireAppliesTo);
        if (obj != null) {
            this.requireAppliesTo_ = obj instanceof Boolean ? (Boolean)obj : Boolean.valueOf(obj.toString());
        }
    }

    private void initPrivacyNotice(IEntity card) throws IdASException, CardException, ParserConfigurationException, SAXException, IOException, ClassCastException {
        this.privacyNotice_ = null;
        String obj = (String)this.getSimpleValueData(card, IdASContext.ICARD_privacyNotice);
        if (obj != null) {
            this.privacyNotice_ = new STSPrivacyPolicy(obj);
        }
    }

    private void initHashSalt(IEntity card) throws IdASException, CardException, ClassCastException {
        this.hashSalt_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_hashSalt);
    }

    private void initTimeLastUpdated(IEntity card) throws IdASException, CardException {
        this.timeLastUpdated_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeLastUpdated);
        if (obj != null) {
            this.timeLastUpdated_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initMasterKey(IEntity card) throws IdASException, CardException, ClassCastException {
        this.masterKey_ = (byte[])this.getSimpleValueData(card, IdASContext.ICARD_masterKey);
    }

    public void setName(String name) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card name.");
        }
        String oldName = this.name_;
        try {
            this.name_ = name.trim();
            this.saveCardName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.name_ = oldName;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setImage(byte[] image, String imageMimeType) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (image == null) {
            throw new CardException("Couldn't set null card image.");
        }
        if (imageMimeType == null) {
            throw new CardException("Couldn't set null card image MIME type.");
        }
        byte[] oldImage = this.image_;
        String oldImageType = this.imageMimeType_;
        this.image_ = image;
        this.imageMimeType_ = imageMimeType;
        try {
            this.saveCardImage();
            this.saveCardImageType();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.image_ = oldImage;
            this.imageMimeType_ = oldImageType;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setIssuerName(String name) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card issuer name.");
        }
        String oldName = this.issuerName_;
        try {
            this.issuerName_ = name.trim();
            this.saveIssuerName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.issuerName_ = oldName;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setTimeExpires(Date date) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        Date oldDate_ = this.timeExpires_;
        try {
            this.timeExpires_ = date;
            this.saveTimeExpires();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.timeExpires_ = oldDate_;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private void saveCard() throws Exception {
        this.saveIsSelfIssued();
        this.saveLanguage();
        this.saveCardId();
        this.saveCardVersion();
        this.saveCardName();
        this.saveCardImage();
        this.saveCardImageType();
        this.saveIssuer();
        this.saveIssuerName();
        this.saveTimeIssued();
        this.saveTimeExpires();
        this.saveSupportedTokenTypes();
        this.saveClaimTypes();
        this.saveTokenServiceList();
        this.saveRequireAppliesTo();
        this.savePrivacyNotice();
        this.saveHashSalt();
        this.saveTimeLastUpdated();
        this.saveMasterKey();
    }

    private void saveIsSelfIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_isSelfIssued);
        attr.addSimpleValue(null, (Object)false);
    }

    private void saveLanguage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_language);
        attr.addSimpleValue(null, (Object)this.language_);
    }

    private void saveCardId() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.HIGGINS_uniqueIdentifier);
        attr.addSimpleValue(null, (Object)this.id_);
    }

    private void saveCardVersion() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_version);
        attr.addSimpleValue(null, (Object)this.version_);
    }

    private void saveCardName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_name);
        attr.addSimpleValue(null, (Object)this.name_);
    }

    private void saveCardImage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_image);
        attr.addSimpleValue(null, (Object)this.image_);
    }

    private void saveCardImageType() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_imageMimeType);
        attr.addSimpleValue(null, (Object)this.imageMimeType_);
    }

    private void saveIssuer() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuer);
        attr.addSimpleValue(null, (Object)this.issuer_);
    }

    private void saveIssuerName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuerName);
        attr.addSimpleValue(null, (Object)this.issuerName_);
    }

    private void saveTimeIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeIssued);
        attr.addSimpleValue(null, (Object)this.timeIssued_);
    }

    private void saveTimeExpires() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_expiredTime);
        attr.addSimpleValue(null, (Object)this.timeExpires_);
    }

    private void saveSupportedTokenTypes() throws IdASException {
        IAttribute attr = this.card_.getAttribute(IdASContext.ICARD_supportedTokenType);
        Iterator olds = attr.getValues();
        while (olds.hasNext()) {
            IAttributeValue old = (IAttributeValue)olds.next();
            old.remove();
        }
        Iterator it = this.supportedTokenTypes_.iterator();
        while (it.hasNext()) {
            URI uri = (URI)it.next();
            attr.addSimpleValue(null, (Object)uri);
        }
    }

    private void saveClaimTypes() throws IdASException {
        IAttribute attr = this.card_.getAttribute(IdASContext.ICARD_supportedClaimType);
        Iterator olds = attr.getValues();
        while (olds.hasNext()) {
            IAttributeValue old = (IAttributeValue)olds.next();
            old.remove();
        }
        Iterator it = this.claimTypes_.iterator();
        while (it.hasNext()) {
            IClaimType claimType = (IClaimType)it.next();
            IComplexAttrValue val = attr.addComplexValue(null);
            val.getSingleValuedAttribute(IdASContext.ICARD_claimTypeType).addSimpleValue(null, (Object)claimType.getType());
            val.getSingleValuedAttribute(IdASContext.ICARD_claimTypeDescription).addSimpleValue(null, (Object)claimType.getDescription());
            val.getSingleValuedAttribute(IdASContext.ICARD_claimTypeName).addSimpleValue(null, (Object)claimType.getDisplayName());
        }
    }

    private void saveTokenServiceList() throws IdASException, TransformerException {
        IAttribute attr = this.card_.getAttribute(IdASContext.ICARD_tokenService);
        Iterator olds = attr.getValues();
        while (olds.hasNext()) {
            IAttributeValue old = (IAttributeValue)olds.next();
            old.remove();
        }
        Iterator it = this.tokenServices_.iterator();
        while (it.hasNext()) {
            ICredentialDescriptor uc;
            ITokenService tokenService = (ITokenService)it.next();
            IComplexAttrValue val = attr.addComplexValue(null);
            IEndpointReference er = tokenService.getEndpointReference();
            if (er != null) {
                val.getSingleValuedAttribute(IdASContext.ICARD_endpoint_address).addSimpleValue(null, (Object)er.getAddress());
                String metadataStr = XMLUtils.elementToString((Element)er.getMetadata());
                val.getSingleValuedAttribute(IdASContext.ICARD_endpoint_metadata).addSimpleValue(null, (Object)metadataStr);
                String identityStr = XMLUtils.elementToString((Element)er.getIdentity());
                val.getSingleValuedAttribute(IdASContext.ICARD_endpoint_identity).addSimpleValue(null, (Object)identityStr);
            }
            if ((uc = tokenService.getUserCredential()) == null) continue;
            val.getSingleValuedAttribute(IdASContext.ICARD_credential_displayCredentialHint).addSimpleValue(null, (Object)uc.getDisplayCredentialHint());
            String credentialStr = XMLUtils.elementToString((Element)uc.asXML());
            val.getSingleValuedAttribute(IdASContext.ICARD_credential_credential).addSimpleValue(null, (Object)credentialStr);
        }
    }

    private void saveRequireAppliesTo() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_requireAppliesTo);
        attr.addSimpleValue(null, (Object)this.requireAppliesTo_);
    }

    private void savePrivacyNotice() throws IdASException, TransformerException, CardException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_privacyNotice);
        if (this.privacyNotice_ != null) {
            IElement elm = this.privacyNotice_.getPrivacyElement();
            if (elm != null) {
                String obj;
                try {
                    obj = (String)elm.getAs(class$java$lang$String == null ? (class$java$lang$String = IdASBasedManagedCard.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (Exception e) {
                    throw new CardException((Throwable)e);
                }
                attr.addSimpleValue(null, (Object)obj);
            }
        } else {
            attr.addSimpleValue(null, null);
        }
    }

    private void saveHashSalt() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_hashSalt);
        attr.addSimpleValue(null, (Object)this.hashSalt_);
    }

    private void saveTimeLastUpdated() throws IdASException {
        this.timeLastUpdated_ = new Date();
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeLastUpdated);
        attr.addSimpleValue(null, (Object)this.timeLastUpdated_);
    }

    private void saveMasterKey() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_masterKey);
        attr.addSimpleValue(null, (Object)this.masterKey_);
    }

    private Object getSimpleValueData(IComplexAttrValue val, URI attribure) throws CardException {
        try {
            ISingleValuedAttribute attr = val.getSingleValuedAttribute(attribure);
            return this.getSimpleValueData(attr);
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private Object getSimpleValueData(IEntity subj, URI attribure) throws CardException {
        try {
            ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribure);
            return this.getSimpleValueData(attr);
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    private Object getSimpleValueData(ISingleValuedAttribute attr) throws IdASException, CardException {
        IAttributeValue v;
        if (attr != null && (v = attr.getValue()) != null) {
            if (v.isSimple()) {
                ISimpleAttrValue sv = (ISimpleAttrValue)v;
                return sv.getData();
            }
            throw new CardException("Attribute " + (attr.getAttrID() != null ? attr.getAttrID().toString() : "") + " contains non simple value");
        }
        return null;
    }

    public IEntity getCardSubject() {
        return this.card_;
    }

    public void applyUpdates() throws InvalidStateException, CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        try {
            this.card_.getContext().applyUpdates();
            this.editMode = false;
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public void beginUpdates() throws InvalidStateException {
        if (this.editMode) {
            throw new InvalidStateException("Already in edit mode.");
        }
        this.editMode = true;
    }

    public void cancelUpdates() throws InvalidStateException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        try {
            this.card_.getContext().cancelUpdates();
            this.editMode = false;
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new InvalidStateException(e.getMessage());
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isEditable() {
        return false;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public boolean isClaimsRetrieved() {
        return false;
    }

    public IInformationCardExtension addExtension(IElement extension) throws CardException {
        throw new CardException("Not implemented");
    }

    public IInformationCardExtension[] getExtensions() {
        return null;
    }

    public boolean hasExtensions() {
        return false;
    }

    public void removeExtension(IInformationCardExtension extension) throws CardException {
        throw new CardException("Not implemented");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

