/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.pwm;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IPwmCard;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.Card;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.common.utils.CardContext;
import org.eclipse.higgins.icard.common.utils.DateConvertor;
import org.eclipse.higgins.icard.common.utils.IdASContext;
import org.eclipse.higgins.icard.common.utils.PwmCardClaimsHelper;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.io.IXMLElementFormat;
import org.eclipse.higgins.icard.io.UnsupportedElementFormatException;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardUtils;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.eclipse.higgins.icard.provider.pwm.IdASBasedPwmCardProvider;
import org.eclipse.higgins.icard.provider.pwm.utils.PwmCardTemplateHelper;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdASBasedPwmCard
extends Card
implements IPwmCard {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$pwm$IdASBasedPwmCard == null ? (class$org$eclipse$higgins$icard$provider$pwm$IdASBasedPwmCard = IdASBasedPwmCard.class$("org.eclipse.higgins.icard.provider.pwm.IdASBasedPwmCard")) : class$org$eclipse$higgins$icard$provider$pwm$IdASBasedPwmCard));
    private IEntity card_ = null;
    private IEntity claimList_ = null;
    private boolean editMode = false;
    private ArrayList tmpClaimValueList_ = null;
    private IdASBasedPwmCardProvider.UserCredentials credentials_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$pwm$IdASBasedPwmCard;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$ISimpleClaim;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$ClaimType;

    public IdASBasedPwmCard() {
    }

    public IdASBasedPwmCard(IdASBasedPwmCardProvider provider, IContext ctx, ICardTemplate template, IdASBasedPwmCardProvider.UserCredentials credentials) throws CardException {
        String picStr;
        ITemplateValue pictureTV;
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        this.provider_ = provider;
        this.credentials_ = credentials;
        this.id_ = URI.create(UUIDGenerator.getUUID());
        this.description_ = "IPwmCard";
        this.isSelfIssued_ = true;
        this.issuer_ = "http://eclipse.org/higgins/2008/passwordmanaged";
        this.issuerName_ = "Higgins password manager";
        this.version_ = "1";
        this.timeIssued_ = new Date();
        ITemplateValue nameTV = template.getTemplateValueByID("cardName");
        if (nameTV != null) {
            this.name_ = nameTV.getValue();
        }
        if ((pictureTV = template.getTemplateValueByID("cardPicture")) != null && (picStr = pictureTV.getValue()) != null && picStr.trim().length() > 0) {
            this.image_ = Base64.decode((String)picStr);
            this.imageMimeType_ = "image/jpeg";
        }
        if (this.image_ == null) {
            this.image_ = provider.getDefaultImage();
            this.imageMimeType_ = provider.getDefaultImageType();
        }
        this.tmpClaimValueList_ = PwmCardTemplateHelper.getClaimsFromCardTemplate(template);
        this.claimTypes_ = PwmCardClaimsHelper.getSupportedClaimTypes();
        this.store(ctx);
        this.setClaims(this.tmpClaimValueList_);
        this.supportedTokenTypes_ = new ArrayList();
    }

    public IdASBasedPwmCard(IdASBasedPwmCardProvider provider, IEntity card, IdASBasedPwmCardProvider.UserCredentials credentials) throws IdASException, CardException {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        this.provider_ = provider;
        this.card_ = card;
        this.credentials_ = credentials;
        this.description_ = "IPwmCard";
        this.issuerName_ = "Higgins password manager";
        this.issuer_ = "http://eclipse.org/higgins/2008/passwordmanaged";
        this.claimTypes_ = PwmCardClaimsHelper.getSupportedClaimTypes();
        this.initClaimListSubject(false);
        this.initFromDS();
        this.supportedTokenTypes_ = new ArrayList();
    }

    public IdASBasedPwmCard(IdASBasedPwmCardProvider provider, IContext ctx, Element card, IdASBasedPwmCardProvider.UserCredentials credentials) throws Exception {
        if (provider == null) {
            throw new CardException("Parameter \"provider\" is null");
        }
        if (card == null) {
            throw new CardException("Parameter \"card\" is null");
        }
        if (credentials == null) {
            throw new CardException("Parameter \"credentials\" is null");
        }
        if (!"RoamingPasswordManagedCard".equals(card.getNodeName())) {
            throw new CardException("Can not init PWM card from element with name " + card.getNodeName());
        }
        this.provider_ = provider;
        this.description_ = "IPwmCard";
        this.issuerName_ = "Higgins password manager";
        this.issuer_ = "http://eclipse.org/higgins/2008/passwordmanaged";
        this.claimTypes_ = PwmCardClaimsHelper.getSupportedClaimTypes();
        this.credentials_ = credentials;
        this.initFromXML(card);
        this.store(ctx);
        this.setClaims(this.tmpClaimValueList_);
        this.supportedTokenTypes_ = new ArrayList();
    }

    private void store(IContext ctx) throws CardException {
        try {
            try {
                this.card_ = ctx.getEntity(this.id_.toString());
                throw new CardException("Couldn't create card. Card with id = " + this.id_ + " already exists.");
            }
            catch (NoSuchEntityException e) {
                this.card_ = ctx.addEntity(IdASContext.ICARD_PwmCard, this.id_.toString());
                this.initClaimListSubject(true);
                this.saveCard();
                ctx.applyUpdates();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            try {
                ctx.cancelUpdates();
            }
            catch (Exception e1) {
                this.log.error((Object)e1);
                throw new CardException((Throwable)e1);
            }
            throw new CardException((Throwable)e);
        }
    }

    private IEntity createClaimListSubject() throws IdASException, CardException {
        if (this.card_ == null) {
            throw new CardException("Variable \"card_\" is null.");
        }
        IContext ctx = this.card_.getContext();
        String clamListSubjectID = UUIDGenerator.getUUID();
        IEntity claimList = ctx.addEntity(IdASContext.ICARD_PwmClaimList, clamListSubjectID);
        IEntity cv = claimList.getSingleValuedAttribute(IdASContext.ICARD_pwmCardReference).addComplexValue((URI)null);
        URI subjRefURI = null;
        try {
            subjRefURI = new URI(this.card_.getEntityID());
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        cv.getSingleValuedAttribute(IdASContext.ICARD_subjectPwmCardReference).addSimpleValue(null, (Object)subjRefURI);
        cv.getSingleValuedAttribute(IdASContext.ICARD_contextPwmCardReference).addSimpleValue(null, (Object)ctx.getContextID());
        return claimList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initClaimListSubject(boolean createNew) throws IdASException, CardException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_pwmClaimValueListRef);
        IValue val = attr.getValue();
        if (val != null) {
            IEntity claimList;
            if (val.isSimple()) throw new CardException("Attribute " + IdASContext.ICARD_pwmClaimValueListRef + " should be complex");
            String subjID = null;
            IEntity listRef = (IEntity)val;
            Object subj = this.getSimpleValueData(listRef, IdASContext.ICARD_pwmClaimValueListSubject);
            if (subj != null) {
                subjID = subj.toString();
            }
            if ((claimList = this.card_.getContext().getEntity(subjID)) == null) {
                throw new CardException("Couldn't get the claim list subject reference for card with ID = " + this.card_.getEntityID() + " .");
            }
            this.claimList_ = claimList;
            return;
        }
        if (!createNew) {
            throw new CardException("Couldn't get the claim list reference for card with ID = " + this.card_.getEntityID() + ". This card doesn't have any value with type" + IdASContext.ICARD_PwmClaimValueListRef + ".");
        }
        this.claimList_ = this.createClaimListSubject();
        IEntity cv = attr.addComplexValue((URI)null);
        URI entityIdURI = null;
        try {
            entityIdURI = new URI(this.claimList_.getEntityID());
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        cv.getSingleValuedAttribute(IdASContext.ICARD_pwmClaimValueListSubject).addSimpleValue(null, (Object)entityIdURI);
        cv.getSingleValuedAttribute(IdASContext.ICARD_pwmClaimValueListContext).addSimpleValue(null, (Object)this.claimList_.getContext().getContextID());
    }

    private void initFromDS() throws ClassCastException, IdASException, CardException {
        this.initIsSelfIssued(this.card_);
        this.initLanguage(this.card_);
        this.initCardId(this.card_);
        this.initCardVersion(this.card_);
        this.initCardName(this.card_);
        this.initCardImage(this.card_);
        this.initCardImageType(this.card_);
        this.initTimeIssued(this.card_);
        this.initTimeExpires(this.card_);
        this.initTimeLastUpdated(this.card_);
        this.initClaims();
    }

    private void initIsSelfIssued(IEntity card) throws IdASException, CardException, ClassCastException {
        this.isSelfIssued_ = true;
    }

    private void initLanguage(IEntity card) throws IdASException, CardException, ClassCastException {
        this.language_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_language);
    }

    private void initCardId(IEntity card) throws IdASException, CardException, ClassCastException {
        String entityID = (String)this.getSimpleValueData(card, IdASContext.HIGGINS_uniqueIdentifier);
        String id = entityID != null ? entityID : "";
        try {
            this.id_ = new URI(id);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private void initCardVersion(IEntity card) throws IdASException, CardException, ClassCastException {
        this.version_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_version);
    }

    private void initCardName(IEntity card) throws IdASException, CardException, ClassCastException {
        this.name_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_name);
    }

    private void initCardImage(IEntity card) throws IdASException, CardException, ClassCastException {
        ByteBuffer bb = (ByteBuffer)this.getSimpleValueData(card, IdASContext.ICARD_image);
        this.image_ = (byte[])(bb != null ? bb.array() : null);
    }

    private void initCardImageType(IEntity card) throws IdASException, CardException, ClassCastException {
        this.imageMimeType_ = (String)this.getSimpleValueData(card, IdASContext.ICARD_imageMimeType);
    }

    private void initTimeIssued(IEntity card) throws IdASException, CardException {
        this.timeIssued_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeIssued);
        if (obj != null) {
            this.timeIssued_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initTimeExpires(IEntity card) throws IdASException, CardException {
        this.timeExpires_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_expiredTime);
        if (obj != null) {
            this.timeExpires_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    private void initTimeLastUpdated(IEntity card) throws IdASException, CardException {
        this.timeLastUpdated_ = null;
        Object obj = this.getSimpleValueData(card, IdASContext.ICARD_timeLastUpdated);
        if (obj != null) {
            this.timeLastUpdated_ = obj instanceof Date ? (Date)obj : DateConvertor.parse((String)obj.toString());
        }
    }

    public void setName(String name) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        String oldName = this.name_;
        try {
            this.name_ = name != null ? name.trim() : null;
            this.saveCardName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.name_ = oldName;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setImage(byte[] image, String imageMimeType) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        byte[] oldImage = this.image_;
        String oldImageType = this.imageMimeType_;
        this.image_ = image;
        this.imageMimeType_ = imageMimeType;
        if (this.image_ == null) {
            this.image_ = ((IdASBasedPwmCardProvider)this.provider_).getDefaultImage();
            this.imageMimeType_ = ((IdASBasedPwmCardProvider)this.provider_).getDefaultImageType();
        }
        try {
            this.saveCardImage();
            this.saveCardImageType();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.image_ = oldImage;
            this.imageMimeType_ = oldImageType;
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void setIssuerName(String name) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new CardException("Couldn't set empty card issuer name.");
        }
        String oldName = this.issuerName_;
        try {
            this.issuerName_ = name.trim();
            this.saveIssuerName();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.issuerName_ = oldName;
            throw new CardException((Throwable)e);
        }
    }

    public void setTimeExpires(Date date) throws CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        Date oldDate_ = this.timeExpires_;
        try {
            this.timeExpires_ = date;
            this.saveTimeExpires();
            this.saveTimeLastUpdated();
        }
        catch (Exception e) {
            this.timeExpires_ = oldDate_;
            throw new CardException((Throwable)e);
        }
    }

    private void saveCard() throws IdASException, CardException {
        this.saveIsSelfIssued();
        this.saveLanguage();
        this.saveCardId();
        this.saveCardVersion();
        this.saveCardName();
        this.saveCardImage();
        this.saveCardImageType();
        this.saveIssuer();
        this.saveIssuerName();
        this.saveTimeIssued();
        this.saveTimeExpires();
        this.saveClaims();
        this.saveTimeLastUpdated();
    }

    private void saveIsSelfIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_isSelfIssued);
        attr.addSimpleValue(null, (Object)this.isSelfIssued_);
    }

    private void saveLanguage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_language);
        attr.addSimpleValue(null, (Object)this.language_);
    }

    private void saveCardId() throws IdASException {
        if (this.id_ == null) {
            throw new IdASException("Id of pwm card is null");
        }
        String id = this.id_.toString();
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.HIGGINS_uniqueIdentifier);
        attr.addSimpleValue(null, (Object)id);
    }

    private void saveCardVersion() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_version);
        attr.addSimpleValue(null, (Object)this.version_);
    }

    private void saveCardName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_name);
        attr.addSimpleValue(null, (Object)this.name_);
    }

    private void saveCardImage() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_image);
        ByteBuffer bb = null;
        if (this.image_ != null) {
            bb = ByteBuffer.wrap(this.image_);
        }
        attr.addSimpleValue(null, (Object)bb);
    }

    private void saveCardImageType() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_imageMimeType);
        attr.addSimpleValue(null, (Object)this.imageMimeType_);
    }

    private void saveIssuer() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuer);
        attr.addSimpleValue(null, (Object)this.issuer_);
    }

    private void saveIssuerName() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_issuerName);
        attr.addSimpleValue(null, (Object)this.issuerName_);
    }

    private void saveTimeIssued() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeIssued);
        attr.addSimpleValue(null, (Object)this.timeIssued_);
    }

    private void saveTimeExpires() throws IdASException {
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_expiredTime);
        attr.addSimpleValue(null, (Object)this.timeExpires_);
    }

    private void saveTimeLastUpdated() throws IdASException {
        this.timeLastUpdated_ = new Date();
        ISingleValuedAttribute attr = this.card_.getSingleValuedAttribute(IdASContext.ICARD_timeLastUpdated);
        attr.addSimpleValue(null, (Object)this.timeLastUpdated_);
    }

    private void saveClaims() throws IdASException, CardException {
        HashMap<String, String> claims = new HashMap<String, String>();
        Iterator values = this.tmpClaimValueList_.iterator();
        while (values.hasNext()) {
            ClaimValue claimValue = (ClaimValue)values.next();
            String val = claimValue.getValue();
            String type = claimValue.getType().getType();
            if (type == null) {
                throw new CardException("Claim type is null.");
            }
            if (PwmCardClaimsHelper.isClaimSupported((String)type)) {
                if (val == null) continue;
                claims.put(type, val);
                continue;
            }
            throw new CardException("Unsupported claim type : " + type);
        }
        Iterator keys = claims.keySet().iterator();
        while (keys.hasNext()) {
            String type = (String)keys.next();
            String value = (String)claims.get(type);
            URI typeURI = null;
            try {
                typeURI = new URI(type);
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException("Wrong claim type URI : \n" + e);
            }
            ISingleValuedAttribute sa = this.claimList_.getSingleValuedAttribute(typeURI);
            sa.addSimpleValue(null, (Object)value.trim());
        }
    }

    public IEntity getCardSubject() throws CardException {
        return this.card_;
    }

    public IEntity getClaimListSubject() throws CardException {
        return this.claimList_;
    }

    public ICardProvider getProvider() {
        return this.provider_;
    }

    private Object getSimpleValueData(IEntity subj, URI attribure) throws CardException {
        try {
            ISingleValuedAttribute attr = subj.getSingleValuedAttribute(attribure);
            return this.getSimpleValueData(attr);
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private Object getSimpleValueData(ISingleValuedAttribute attr) throws IdASException, CardException {
        IValue v;
        if (attr != null && (v = attr.getValue()) != null) {
            if (v.isSimple()) {
                ISimpleValue sv = (ISimpleValue)v;
                return sv.getData();
            }
            throw new CardException("Attribute " + (attr.getType() != null ? attr.getType().toString() : "") + " contains non simple value");
        }
        return null;
    }

    public void applyUpdates() throws InvalidStateException, CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        try {
            this.card_.getContext().applyUpdates();
            this.card_.getContext().close();
            this.editMode = false;
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public void beginUpdates() throws InvalidStateException {
        if (this.editMode) {
            throw new InvalidStateException("Already in edit mode.");
        }
        try {
            IContext ctx = this.card_.getContext();
            if (!ctx.isOpen(null)) {
                AuthNNamePasswordMaterials credential = new AuthNNamePasswordMaterials(ctx, this.credentials_.getName(), this.credentials_.getPassword());
                ctx.open((IAuthNMaterials)credential);
            } else {
                this.log.warn((Object)"Unexpected situation. The context associated with card entity is already open.");
            }
            this.editMode = true;
        }
        catch (IdASException e) {
            this.log.error((Object)e);
            throw new IllegalStateException(e);
        }
    }

    public void cancelUpdates() throws InvalidStateException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        try {
            this.card_.getContext().cancelUpdates();
            this.initFromDS();
            this.card_.getContext().close();
            this.editMode = false;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new InvalidStateException((Throwable)e);
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isEditable() {
        return true;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new UnsupportedOperationException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException, CardException {
        if (!this.editMode) {
            throw new InvalidStateException("Not in edit mode.");
        }
        if (copyFrom == null) {
            throw new InvalidClaimException("Passed claim is null.");
        }
        if (!(copyFrom instanceof ISimpleClaim)) {
            throw new InvalidClaimException("Provider \"" + this.getProvider().getName() + "\" supports only claims with type " + (class$org$eclipse$higgins$icard$ISimpleClaim == null ? (class$org$eclipse$higgins$icard$ISimpleClaim = IdASBasedPwmCard.class$("org.eclipse.higgins.icard.ISimpleClaim")) : class$org$eclipse$higgins$icard$ISimpleClaim).getName());
        }
        ISimpleClaim simpleClaim = (ISimpleClaim)copyFrom;
        List lst = simpleClaim.getValues();
        if (lst == null) {
            throw new InvalidClaimException("Passed claim does not contain the values list.");
        }
        String obj = lst.size() != 0 ? (String)lst.get(0) : null;
        String value = obj != null ? obj.toString() : "";
        IClaimType cType = simpleClaim.getType();
        if (cType == null) {
            throw new InvalidTypeException("Claim type is null.");
        }
        String type = cType.getType();
        if (!PwmCardClaimsHelper.isClaimSupported((String)type)) {
            throw new CardException("Password managed card does not support claim type :" + type);
        }
        ClaimType newCT = PwmCardClaimsHelper.getClaimType((String)type);
        ClaimValue cv = new ClaimValue((ISimpleClaimType)newCT, value, (ICard)this);
        try {
            this.setClaimValue(type, value);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        return cv;
    }

    private void setClaimValue(String type, String value) throws CardException, UnsupportedEncodingException, IdASException {
        URI typeURI = null;
        try {
            typeURI = new URI(type);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        this.claimList_.getSingleValuedAttribute(typeURI).addSimpleValue(null, (Object)value);
        this.saveTimeLastUpdated();
    }

    private String getClaimValue(String type) throws CardException {
        String dirtyVal;
        URI typeURI = null;
        try {
            typeURI = new URI(type);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        String value = null;
        value = dirtyVal = (String)this.getSimpleValueData(this.claimList_, typeURI);
        return value;
    }

    private void initClaims() throws CardException {
        ArrayList<ClaimValue> claimValueList = new ArrayList<ClaimValue>();
        Iterator itr = PwmCardClaimsHelper.getSupportedClaimTypes().iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof ClaimType)) {
                throw new CardException("Instance of " + (class$org$eclipse$higgins$icard$common$ClaimType == null ? (class$org$eclipse$higgins$icard$common$ClaimType = IdASBasedPwmCard.class$("org.eclipse.higgins.icard.common.ClaimType")) : class$org$eclipse$higgins$icard$common$ClaimType).getName() + " expected instead of " + obj.getClass().getName());
            }
            ClaimType cType = (ClaimType)obj;
            String type = cType.getType();
            String val = this.getClaimValue(type);
            ClaimValue cValue = new ClaimValue((ISimpleClaimType)cType, val, (ICard)this);
            claimValueList.add(cValue);
        }
        this.setClaims(claimValueList);
    }

    public IClaim getClaimByLocalName(String typeLocalName) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        return null;
    }

    public ICredentialDescriptor[] getRequiredCredentials() {
        return null;
    }

    public IClaim getClaim(String type) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        if (this.claimValues_ == null) {
            throw new CardException("Claims are not initialized");
        }
        if (this.claimValues_.containsKey(type)) {
            return (IClaim)this.claimValues_.get(type);
        }
        return null;
    }

    public Iterator getClaims() throws AuthenticationRequiredException, CardException {
        if (this.claimValues_ == null) {
            throw new CardException("Claims are not initialized");
        }
        return this.claimValues_.values().iterator();
    }

    public String getType() {
        return "IPwmCard";
    }

    public void initFromXML(Element card) throws CardException, DOMException {
        Element informationCardMetaData = XMLUtils.getChildElement((Element)card, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"InformationCardMetaData");
        if (informationCardMetaData == null) {
            throw new CardException("Can not find \"InformationCardMetaData\" element.");
        }
        this.language_ = null;
        if (informationCardMetaData.hasAttribute("xml:lang")) {
            this.language_ = informationCardMetaData.getAttribute("xml:lang");
        }
        Element informationCardPrivateData = XMLUtils.getChildElement((Element)card, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"InformationCardPrivateData");
        this.id_ = CardUtils.parseCardId((Element)informationCardMetaData);
        this.version_ = CardUtils.parseCardVersion((Element)informationCardMetaData);
        this.name_ = CardUtils.parseCardName((Element)informationCardMetaData);
        this.image_ = CardUtils.parseCardImage((Element)informationCardMetaData);
        this.imageMimeType_ = CardUtils.parseCardImageType((Element)informationCardMetaData);
        this.timeIssued_ = CardUtils.parseTimeIssued((Element)informationCardMetaData);
        this.timeExpires_ = CardUtils.parseTimeExpires((Element)informationCardMetaData);
        this.issuerID_ = CardUtils.parseIssuerID((Element)informationCardMetaData);
        this.timeLastUpdated_ = CardUtils.parseTimeLastUpdated((Element)informationCardMetaData);
        this.tmpClaimValueList_ = new ArrayList(IdASBasedPwmCard.parseClaimValues(informationCardPrivateData).values());
    }

    protected static HashMap parseClaimValues(Element privateData) throws CardException {
        HashMap<String, ClaimValue> tmpClaimValueMap_ = new HashMap<String, ClaimValue>();
        Element claimValueList = XMLUtils.getChildElement((Element)privateData, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"ClaimValueList");
        if (claimValueList == null) {
            return tmpClaimValueMap_;
        }
        NodeList claimValues = claimValueList.getChildNodes();
        int len = claimValues.getLength();
        for (int i = 0; i < len; ++i) {
            String value;
            Node node = claimValues.item(i);
            if (node.getNodeType() != 1 || !"ClaimValue".equals(node.getLocalName()) || !"http://schemas.xmlsoap.org/ws/2005/05/identity".equals(node.getNamespaceURI())) continue;
            Element elm = (Element)node;
            String uri = elm.getAttribute("Uri");
            if (uri == null || uri.trim().length() == 0) {
                throw new CardException("Couldn't get \"uri\" attribute of ClaimValue element");
            }
            Element valueElm = XMLUtils.getChildElement((Element)elm, (String)"http://schemas.xmlsoap.org/ws/2005/05/identity", (String)"Value");
            String string = value = valueElm != null ? XMLUtils.getTextContent((Element)valueElm) : "";
            if (value == null) continue;
            ClaimValue claimValue = new ClaimValue((ISimpleClaimType)PwmCardClaimsHelper.getClaimType((String)uri), value);
            tmpClaimValueMap_.put(uri, claimValue);
        }
        return tmpClaimValueMap_;
    }

    public IElement toElement(IElementFormat format) throws CardException, CardIOException, UnsupportedElementFormatException {
        if (!this.isFormatSupported(format)) {
            throw new CardException("Unsupported element format: " + format);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element card = doc.createElementNS("http://www.eclipse.org/higgins/2008/06/backup", "RoamingPasswordManagedCard");
            Element metaData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
            if (this.language_ != null) {
                metaData.setAttribute("xml:lang", this.language_);
            } else {
                metaData.setAttribute("xml:lang", "en");
            }
            card.appendChild(metaData);
            this.addCardReference(doc, metaData);
            this.addCardName(doc, metaData);
            this.addCardImage(doc, metaData);
            this.addIssuer(doc, metaData);
            this.addTimeIssued(doc, metaData);
            this.addTimeExpires(doc, metaData);
            this.addClaimTypes(doc, metaData);
            this.addIsSelfIssued(doc, metaData);
            this.addTimeLastUpdated(doc, metaData);
            this.addIssuerID(doc, metaData);
            this.addIssuerName(doc, metaData);
            this.addBackgroundColor(doc, metaData);
            Element privateData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardPrivateData");
            Element claimValueList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValueList");
            Iterator values = this.claimValues_.values().iterator();
            while (values.hasNext()) {
                ClaimValue claim = (ClaimValue)values.next();
                String claimType = claim.getType().getType();
                Element claimValue = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValue");
                claimValue.setAttribute("Uri", claimType);
                Element value = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Value");
                value.appendChild(doc.createTextNode(claim.getValue()));
                claimValue.appendChild(value);
                claimValueList.appendChild(claimValue);
            }
            privateData.appendChild(claimValueList);
            card.appendChild(privateData);
            IOElement element = new IOElement();
            element.set((Object)card);
            return element;
        }
        catch (Exception e) {
            this.log.error((Object)"Can't export card", (Throwable)e);
            throw new CardException("Can't export card", (Throwable)e);
        }
    }

    private void addIsSelfIssued(Document doc, Element informationCardMetaData) {
        Element IsSelfIssued = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IsSelfIssued");
        informationCardMetaData.appendChild(IsSelfIssued);
        XMLUtils.setTextContent((Element)IsSelfIssued, (String)"true");
    }

    private void addIssuerName(Document doc, Element informationCardMetaData) {
        Element IssuerName = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerName");
        informationCardMetaData.appendChild(IssuerName);
        XMLUtils.setTextContent((Element)IssuerName, (String)"Self");
    }

    private void addIssuerID(Document doc, Element informationCardMetaData) {
        Element issuerID = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerId");
        informationCardMetaData.appendChild(issuerID);
        if (this.issuerID_ != null) {
            XMLUtils.setTextContent((Element)issuerID, (String)CardCryptography.encodeBase64((byte[])this.issuerID_, (int)0));
        }
    }

    private void addTimeLastUpdated(Document doc, Element informationCardMetaData) {
        Element timeLastUpdated = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeLastUpdated");
        informationCardMetaData.appendChild(timeLastUpdated);
        String time = DateConvertor.format((Date)this.timeLastUpdated_);
        XMLUtils.setTextContent((Element)timeLastUpdated, (String)time);
    }

    private void addBackgroundColor(Document doc, Element informationCardMetaData) {
        Element bgcolor = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "BackgroundColor");
        informationCardMetaData.appendChild(bgcolor);
        XMLUtils.setTextContent((Element)bgcolor, (String)"0");
    }

    private void addCardReference(Document doc, Element root) {
        Element ref = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
        root.appendChild(ref);
        Element id = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardId");
        XMLUtils.setTextContent((Element)id, (String)this.id_.toString());
        ref.appendChild(id);
        Element version = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardVersion");
        XMLUtils.setTextContent((Element)version, (String)this.version_);
        ref.appendChild(version);
    }

    private void addCardName(Document doc, Element root) {
        if (this.name_ != null) {
            Element name = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardName");
            XMLUtils.setTextContent((Element)name, (String)this.name_);
            root.appendChild(name);
        }
    }

    private void addCardImage(Document doc, Element root) {
        if (this.image_ != null) {
            Element image = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardImage");
            image.setAttribute("MimeType", this.imageMimeType_);
            XMLUtils.setTextContent((Element)image, (String)CardCryptography.encodeBase64((byte[])this.image_, (int)0));
            root.appendChild(image);
        }
    }

    private void addIssuer(Document doc, Element root) {
        Element issuer = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Issuer");
        XMLUtils.setTextContent((Element)issuer, (String)this.issuer_);
        root.appendChild(issuer);
    }

    private void addTimeIssued(Document doc, Element root) {
        String time = DateConvertor.format((Date)this.timeIssued_);
        Element timeIssued = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeIssued");
        XMLUtils.setTextContent((Element)timeIssued, (String)time);
        root.appendChild(timeIssued);
    }

    private void addTimeExpires(Document doc, Element root) {
        if (this.timeExpires_ != null) {
            String time = DateConvertor.format((Date)this.timeExpires_);
            Element timeExpires = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeExpires");
            XMLUtils.setTextContent((Element)timeExpires, (String)time);
            root.appendChild(timeExpires);
        }
    }

    private void addClaimTypes(Document doc, Element root) {
        Element claimTypeList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimTypeList");
        root.appendChild(claimTypeList);
        Iterator it = this.claimTypes_.iterator();
        while (it.hasNext()) {
            IClaimType type = (IClaimType)it.next();
            if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type.getType())) continue;
            Element claimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimType");
            claimType.setAttribute("Uri", type.getType().toString());
            claimTypeList.appendChild(claimType);
            Element displayTag = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag");
            XMLUtils.setTextContent((Element)displayTag, (String)type.getDisplayName());
            claimType.appendChild(displayTag);
            Element description = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Description");
            XMLUtils.setTextContent((Element)description, (String)type.getDescription());
            claimType.appendChild(description);
        }
    }

    public boolean isFormatSupported(IElementFormat format) {
        if (format.getFormatID() == "XML") {
            IXMLElementFormat xmlf = (IXMLElementFormat)format;
            QName[] names = xmlf.getElementNames();
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(CardContext.QN_HC_ROAMING_PWM_CARD)) continue;
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

