/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.pwm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.UserCacheKey;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.BasicCardProvider;
import org.eclipse.higgins.icard.common.utils.IdASContext;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.provider.pwm.IdASBasedPwmCard;
import org.eclipse.higgins.icard.provider.pwm.utils.PwmCardTemplateHelper;
import org.eclipse.higgins.icard.registry.ICardRegistry;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.RegistryConfigurationException;
import org.w3c.dom.Element;

public class IdASBasedPwmCardProvider
extends BasicCardProvider {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$pwm$IdASBasedPwmCardProvider == null ? (class$org$eclipse$higgins$icard$provider$pwm$IdASBasedPwmCardProvider = IdASBasedPwmCardProvider.class$("org.eclipse.higgins.icard.provider.pwm.IdASBasedPwmCardProvider")) : class$org$eclipse$higgins$icard$provider$pwm$IdASBasedPwmCardProvider));
    private static final String CONTEXT_ID = "context.id";
    private static final String DISCOVERY_FILE = "discovery.filename";
    private static final String DEFAULT_IMAGE_FILE = "defaultImage.file";
    private static final String DEFAULT_IMAGE_TYPE = "defaultImage.mimeType";
    private IConfiguration config_ = null;
    private String id_ = "org.eclipse.higgins.icard.provider.pwm";
    private String name_ = "Password managed I-Card Provider Plug-in";
    private static ICache cardCache = CacheProviderFactory.getCacheProvider().getCache("cardprovider.pwm");
    private static boolean isNoCache = true;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$pwm$IdASBasedPwmCardProvider;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IPwmCard;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public void setID(String id) throws Exception {
        if (this.config_ != null) {
            throw new Exception("Provider's id can't be modified.");
        }
        this.id_ = id;
    }

    public IConfiguration getConfiguration() {
        if (this.config_ == null) {
            try {
                this.config_ = ICardRegistry.getInstance().getConfiguration((IServiceProvider)this);
            }
            catch (RegistryConfigurationException e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        return this.config_;
    }

    private IContext getContext(UserCredentials credentials) throws CardException {
        String disc = (String)this.getConfiguration().getProperty(DISCOVERY_FILE);
        FileDiscovery factories = new FileDiscovery(new File(disc));
        IdASRegistry registry = IdASRegistry.getInstance();
        registry.setDiscovery((IDiscovery)factories);
        IContext ctx = null;
        if (this.config_ != null) {
            String contextID = (String)this.getConfiguration().getProperty(CONTEXT_ID);
            if (contextID == null) {
                throw new CardException("Can not get \"context.id\" configuration property.");
            }
            try {
                ctx = registry.createContext(contextID);
                AuthNNamePasswordMaterials credential = new AuthNNamePasswordMaterials(ctx, credentials.getName(), credentials.getPassword());
                ctx.open((IAuthNMaterials)credential);
                return ctx;
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
        return null;
    }

    private void ensureInCache(UserCredentials userCrds) throws CardException, IdASException {
        UserCacheKey key = new UserCacheKey(userCrds.getName());
        if (!cardCache.isKeyInCache((ICacheKey)key)) {
            this.log.info((Object)("Load all Password Manager cards by userID:" + key.getKey().toString()));
            List lstCards = this.loadCardsFromIdas(userCrds);
            HashMap<String, IdASBasedPwmCard> cachedCards = new HashMap<String, IdASBasedPwmCard>();
            Iterator iterator = lstCards.iterator();
            while (iterator.hasNext()) {
                IdASBasedPwmCard card = (IdASBasedPwmCard)((Object)iterator.next());
                cachedCards.put(card.getID(), card);
            }
            cardCache.put((ICacheKey)key, cachedCards);
            this.log.info((Object)(key.getKey().toString() + " cards cached."));
        }
    }

    private Map getCachedCards(UserCredentials userCrds) {
        UserCacheKey key = new UserCacheKey(userCrds.getName());
        if (cardCache.isKeyInCache((ICacheKey)key)) {
            return (Map)cardCache.get((ICacheKey)key);
        }
        throw new CacheException("Card Cache for user " + userCrds.getName() + " was not inited!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadCardsFromIdas(UserCredentials userCrds) throws IdASException, CardException {
        IContext ctx = this.getContext(userCrds);
        if (ctx != null) {
            ArrayList<IdASBasedPwmCard> cards = new ArrayList<IdASBasedPwmCard>();
            try {
                IFilter filter = ctx.buildFilter();
                IFilterEntityTypeAssertion typeAssertion = ctx.buildEntityTypeAssertion();
                typeAssertion.setAssertionValue(IdASContext.ICARD_PwmCard);
                filter.setAssertion((IFilterAssertion)typeAssertion);
                Iterator subjList = ctx.getEntities(filter);
                while (subjList.hasNext()) {
                    IEntity subj = (IEntity)subjList.next();
                    if (!IdASContext.ICARD_PwmCard.equals(subj.getModel().getType())) continue;
                    IdASBasedPwmCard card = new IdASBasedPwmCard(this, subj, userCrds);
                    cards.add(card);
                }
                ArrayList<IdASBasedPwmCard> arrayList = cards;
                return arrayList;
            }
            finally {
                try {
                    ctx.close();
                }
                catch (IdASException e) {
                    this.log.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
        }
        return null;
    }

    public Iterator getICards(CallbackHandler authHandler) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            if (isNoCache) {
                return this.loadCardsFromIdas(userCrds).iterator();
            }
            this.ensureInCache(userCrds);
            Map cards = this.getCachedCards(userCrds);
            return new ArrayList(cards.values()).iterator();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCard(CallbackHandler authHandler, ICard card) throws CardException {
        block15: {
            if (authHandler == null) {
                throw new CardException("Parameter \"authHandler\" is null");
            }
            if (card == null) {
                throw new CardException("Parameter \"card\" is null");
            }
            UserCredentials userCrds = this.authenticate(authHandler);
            IContext ctx = this.getContext(userCrds);
            if (ctx != null) {
                try {
                    if (!(card instanceof IdASBasedPwmCard)) break block15;
                    try {
                        IdASBasedPwmCard crd = (IdASBasedPwmCard)card;
                        if (!isNoCache) {
                            this.ensureInCache(userCrds);
                            Map cards = this.getCachedCards(userCrds);
                            cards.remove(crd.getID());
                        }
                        String subjId = crd.getCardSubject().getEntityID();
                        IEntity subj = ctx.getEntity(subjId);
                        subj.remove();
                        String claimId = crd.getClaimListSubject().getEntityID();
                        IEntity claimList = ctx.getEntity(claimId);
                        claimList.remove();
                        ctx.applyUpdates();
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                        try {
                            ctx.cancelUpdates();
                        }
                        catch (Exception e1) {
                            this.log.error((Object)e1);
                            throw new CardException((Throwable)e1);
                        }
                        throw new CardException((Throwable)e);
                    }
                }
                finally {
                    try {
                        ctx.close();
                    }
                    catch (IdASException e) {
                        this.log.error((Object)e);
                        throw new CardException((Throwable)e);
                    }
                }
            }
        }
    }

    public String getID() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canCreateCard(CallbackHandler authHandler, String id, Properties props) {
        if (authHandler == null) {
            this.log.info((Object)"Can not create card. Parameter \"authHandler\" is null.");
            return false;
        }
        if (id == null) {
            this.log.info((Object)"Can not create card. Parameter \"id\" is null.");
            return false;
        }
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            if (!isNoCache) {
                this.ensureInCache(userCrds);
                Map cards = this.getCachedCards(userCrds);
                return cards.containsKey(id);
            }
            IContext ctx = this.getContext(userCrds);
            if (ctx == null) return false;
            try {
                ctx.getEntity(id);
                this.log.info((Object)("Can not create card. Card with ID = " + id + " already exists."));
                boolean bl = false;
                return bl;
            }
            catch (NoSuchEntityException e) {
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    ctx.close();
                }
                catch (IdASException e) {
                    this.log.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return false;
    }

    public String getDescription() {
        return "IdAS-based CardSpace-interoperable personal I-Card provider";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ICard getICardByID(CallbackHandler authHandler, String CardID) throws CardException {
        try {
            UserCredentials userCrds = this.authenticate(authHandler);
            if (!isNoCache) {
                this.ensureInCache(userCrds);
                Map cards = this.getCachedCards(userCrds);
                return (IdASBasedPwmCard)((Object)cards.get(CardID));
            }
            IContext ctx = this.getContext(userCrds);
            if (ctx == null) return null;
            try {
                IdASBasedPwmCard card;
                IEntity subj = ctx.getEntity(CardID);
                IdASBasedPwmCard idASBasedPwmCard = card = new IdASBasedPwmCard(this, subj, userCrds);
                return idASBasedPwmCard;
            }
            finally {
                try {
                    ctx.close();
                }
                catch (IdASException e) {
                    this.log.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid) throws CardException {
        if (!this.getID().equals(cuid.getProviderID())) {
            this.log.debug((Object)("ProviderID of requested CUID (" + cuid.getProviderID() + ") is not equal to this providerID (" + this.getID() + ")."));
            return null;
        }
        ICard crd = this.getICardByID(authHandler, cuid.getCardID());
        if (crd == null) {
            this.log.debug((Object)("Can not find any card with ID = " + cuid.getCardID()));
            return null;
        }
        String issuer = cuid.getIssuer();
        if (issuer != null && issuer.equals(crd.getIssuer())) {
            return crd;
        }
        this.log.debug((Object)("Wrong issuer for card with ID = " + cuid.getCardID() + ". Requested issuer = " + issuer + ", real issuer = " + crd.getIssuer()));
        return null;
    }

    private UserCredentials authenticate(CallbackHandler authHandler) throws CardException {
        NameCallback nc = new NameCallback("User name: ");
        Callback[] callbacks = new Callback[]{nc};
        try {
            authHandler.handle(callbacks);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
        String userName = nc.getName();
        if (userName == null || userName.trim().length() == 0) {
            throw new CardException("Empty user name.");
        }
        return new UserCredentials(userName, "");
    }

    public String getDefaultImageType() {
        return (String)this.getConfiguration().getProperty(DEFAULT_IMAGE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDefaultImage() {
        this.log.trace((Object)"IdASBasedPersonalCardProvider.getDefaultImage()");
        String fileName = (String)this.getConfiguration().getProperty(DEFAULT_IMAGE_FILE);
        if (fileName != null) {
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                long fileLength = file.length();
                if (fileLength > Integer.MAX_VALUE) {
                    this.log.error((Object)"IdASBasedPwmCardProvider.getDefaultImage - too long default image file size.");
                    return null;
                }
                int size = (int)fileLength;
                int offset = 0;
                int len = size;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    int count = 0;
                    byte[] image = new byte[size];
                    do {
                        if ((count = fis.read(image, offset, len)) == len) continue;
                        offset += count;
                        len -= count;
                    } while (count != -1);
                    byte[] byArray = image;
                    return byArray;
                }
                catch (IOException e) {
                    this.log.error((Object)e);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        this.log.error((Object)e);
                    }
                }
            }
            this.log.error((Object)("IdASBasedPwmCardProvider.getDefaultImage - default image file " + fileName + " does not exist."));
        } else {
            this.log.error((Object)"IdASBasedPwmCardProvider.getDefaultImage - can not get the name of default image.");
        }
        return null;
    }

    public ICard createCard(CallbackHandler authHandler, ICardTemplate template) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        IContext ctx = this.getContext(userCrds);
        if (ctx != null) {
            try {
                IdASBasedPwmCard card = new IdASBasedPwmCard(this, ctx, template, userCrds);
                if (!isNoCache) {
                    this.ensureInCache(userCrds);
                    Map cards = this.getCachedCards(userCrds);
                    cards.put(card.getID(), card);
                }
                IdASBasedPwmCard idASBasedPwmCard = card;
                return idASBasedPwmCard;
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
            finally {
                try {
                    ctx.close();
                }
                catch (IdASException e) {
                    this.log.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
        }
        throw new CardException("Can not initialize the IdAS context.");
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return new ICardTemplate[]{PwmCardTemplateHelper.getCardTemplate((ICardProvider)this)};
    }

    public Iterator getICardsByFormat(CallbackHandler authHandler, IElementFormat format) throws CardException {
        ArrayList cards = new ArrayList();
        Iterator itr = this.getICards(authHandler);
        while (itr.hasNext()) {
            ICard card;
            Object o = itr.next();
            if (!(o instanceof ICard) || !(card = (ICard)o).isFormatSupported(format)) continue;
            cards.add(o);
        }
        return cards.iterator();
    }

    public Class[] getSupportedTypes() {
        return new Class[]{class$org$eclipse$higgins$icard$IPwmCard == null ? (class$org$eclipse$higgins$icard$IPwmCard = IdASBasedPwmCardProvider.class$("org.eclipse.higgins.icard.IPwmCard")) : class$org$eclipse$higgins$icard$IPwmCard};
    }

    public ICardTemplate getCardCreationTemplatesByID(CallbackHandler authHandler, String ID) {
        if ("PwmCardTemplate".equals(ID)) {
            return PwmCardTemplateHelper.getCardTemplate((ICardProvider)this);
        }
        return null;
    }

    public ICard createCard(CallbackHandler authHandler, String id, Properties props) throws CardException {
        throw new CardException("Not implemented");
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        return this.getICardByCUID(authHandler, cuid);
    }

    public ICard parseCardElement(CallbackHandler authHandler, IElement element) {
        if (element == null) {
            return null;
        }
        try {
            Element card = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = IdASBasedPwmCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            if (card == null) {
                return null;
            }
            IdASBasedPwmCard c = new IdASBasedPwmCard();
            c.initFromXML(card);
            return c;
        }
        catch (Exception e) {
            this.log.warn((Object)e, (Throwable)e);
            return null;
        }
    }

    public ICard importICard(CallbackHandler authHandler, IElement element) throws CardException {
        if (authHandler == null) {
            throw new CardException("Parameter \"authHandler\" is null");
        }
        UserCredentials userCrds = this.authenticate(authHandler);
        IContext ctx = this.getContext(userCrds);
        if (ctx != null) {
            try {
                Element el = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = IdASBasedPwmCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
                IdASBasedPwmCard card = new IdASBasedPwmCard(this, ctx, el, userCrds);
                if (!isNoCache) {
                    this.ensureInCache(userCrds);
                    Map cards = this.getCachedCards(userCrds);
                    cards.put(card.getID(), card);
                }
                IdASBasedPwmCard idASBasedPwmCard = card;
                return idASBasedPwmCard;
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
            finally {
                try {
                    ctx.close();
                }
                catch (IdASException e) {
                    this.log.error((Object)e);
                    throw new CardException((Throwable)e);
                }
            }
        }
        throw new CardException("Can not initialize the IdAS context.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class UserCredentials {
        private String name_;
        private String password_;

        public UserCredentials(String name, String password) {
            this.name_ = name;
            this.password_ = password;
        }

        public String getName() {
            return this.name_;
        }

        public String getPassword() {
            return this.password_;
        }
    }
}

