/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.pwm.utils;

import java.util.ArrayList;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.common.CardTemplate;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.TemplateContainer;
import org.eclipse.higgins.icard.common.TemplateValue;
import org.eclipse.higgins.icard.common.utils.PwmCardClaimsHelper;

public class PwmCardTemplateHelper {
    public static final String CARD_TEMPLATE_ID = "PwmCardTemplate";
    public static final String CARD_NAME = "cardName";
    public static final String CARD_PICTURE = "cardPicture";
    public static final String CLAIM_LIST = "claimList";
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IPwmCard;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$ITemplateContainer;

    public static CardTemplate getCardTemplate(ICardProvider provider) {
        CardTemplate cardTemplate = new CardTemplate(CARD_TEMPLATE_ID, "Password manager card template", "Password manager card template", provider, class$org$eclipse$higgins$icard$IPwmCard == null ? (class$org$eclipse$higgins$icard$IPwmCard = PwmCardTemplateHelper.class$("org.eclipse.higgins.icard.IPwmCard")) : class$org$eclipse$higgins$icard$IPwmCard);
        cardTemplate.addTemplateElement((ITemplateElement)TemplateValue.createTextFieldTemplate((String)CARD_NAME, (String)"", null, (String)"Card name", (String)"Card name", null, (boolean)false));
        cardTemplate.addTemplateElement((ITemplateElement)TemplateValue.createFileTemplate((String)CARD_PICTURE, null, (String)"Card picture", (String)"Card picture", (boolean)false));
        TemplateContainer claims = new TemplateContainer(CLAIM_LIST, "Information that will be sent with this card", "Claim list");
        ArrayList claimTypes = PwmCardClaimsHelper.getSupportedClaimTypes();
        int size = claimTypes.size();
        for (int i = 0; i < size; ++i) {
            ClaimType ct = (ClaimType)claimTypes.get(i);
            String pattern = null;
            TemplateValue val = TemplateValue.createTextFieldTemplate((String)ct.getType(), (String)"", pattern, (String)ct.getDescription(), (String)ct.getDisplayName(), null, (boolean)false);
            claims.addTemplateElement((ITemplateElement)val);
        }
        cardTemplate.addTemplateElement((ITemplateElement)claims);
        return cardTemplate;
    }

    public static ArrayList getClaimsFromCardTemplate(ICardTemplate template) throws CardException {
        if (template == null) {
            throw new CardException("Parameter \"template\" is null.");
        }
        if (!CARD_TEMPLATE_ID.equals(template.getID())) {
            throw new CardException("Unexpected template ID : " + template.getID());
        }
        ITemplateElement te = template.getTemplateElementByID(CLAIM_LIST);
        if (te == null) {
            throw new CardException("Claim list template container was not found.");
        }
        if (!(te instanceof ITemplateContainer)) {
            throw new CardException("Claim list expected to be an instance of " + (class$org$eclipse$higgins$icard$ITemplateContainer == null ? (class$org$eclipse$higgins$icard$ITemplateContainer = PwmCardTemplateHelper.class$("org.eclipse.higgins.icard.ITemplateContainer")) : class$org$eclipse$higgins$icard$ITemplateContainer).getName());
        }
        ITemplateContainer claimContainer = (ITemplateContainer)te;
        ArrayList supportedClaimTypes = PwmCardClaimsHelper.getSupportedClaimTypes();
        ArrayList<ClaimValue> res = new ArrayList<ClaimValue>();
        int size = supportedClaimTypes.size();
        for (int i = 0; i < size; ++i) {
            ClaimType claimType = (ClaimType)supportedClaimTypes.get(i);
            String type = claimType.getType();
            ITemplateValue value = claimContainer.getTemplateValueByID(type);
            if (value == null) continue;
            String val = value.getValue();
            res.add(new ClaimValue((ISimpleClaimType)claimType, val));
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

