/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.manager;

/**
 * This class attempts to erase characters echoed to the console.
 */

class PasswordMaskerThread extends Thread {
   private volatile boolean haltThread;
   private char echochar = ' ';

   public PasswordMaskerThread(String prompt) {
      System.out.print(prompt);
   }

   public void run() {

      int priority = Thread.currentThread().getPriority();
      Thread.currentThread().setPriority(Thread.MAX_PRIORITY);

      try {
         haltThread = true;
         while(haltThread) {           
           System.out.print("\010" + echochar);
           try {
              // attempt masking at this rate
              Thread.currentThread().sleep(1);
           }catch (InterruptedException iex) {
              Thread.currentThread().interrupt();
              return;
           }
         }
      } finally { // restore the original priority
         Thread.currentThread().setPriority(priority);
      }
   }

   public void haltMasking() {
      this.haltThread = false;
   }
}

