/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.manager;

import java.io.*;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

/**
 * This class prompts the user for a password and attempts to mask input with "*"
 */

public class PasswordPrompt {

  /**
   *@param input stream to be used (e.g. System.in)
   *@param prompt The prompt to display to the user.
   *@return The password as entered by the user.
   */

   public static final char[] getPassword(InputStream in, String prompt) throws IOException {
      PasswordMaskerThread maskingthread = new PasswordMaskerThread(prompt);
     Thread thread = new Thread(maskingthread);
      thread.start();
	
      char[] lineBuffer;
      char[] buf;

      buf = lineBuffer = new char[128];

      int bufferRemaining = buf.length;
      int offset = 0;
      int c;
      
//      while(true)
//      {
//    	  c = in.read();
//    	  
//    	  if (c == '\n')
//    	  {
//    		  break;
//    	  } else if (c == '\r')
//    	  {
//    		  // check the next character if it is newline or null.
//    		  // if so remove those chars from the result.
//              int nextChar = in.read();
//              if ((nextChar != '\n') && (nextChar != -1)) {
//                 if (!(in instanceof PushbackInputStream)) {
//                    in = new PushbackInputStream(in);
//                 }
//                 ((PushbackInputStream)in).unread(nextChar);
//               } else {
//                 break;
//               }
//    	  }  
//    	  
//          if (--bufferRemaining < 0) {
//              buf = new char[offset + 128];
//              bufferRemaining = buf.length - offset - 1;
//              System.arraycopy(lineBuffer, 0, buf, 0, offset);
//              Arrays.fill(lineBuffer, ' ');
//              lineBuffer = buf;
//           }
//           buf[offset++] = (char) c;
//           break;    		      	  
//      }
    

      loop:   while (true) {
         switch (c = in.read()) {
            case -1:
            case '\n':
               break loop;

            case '\r':
               int c2 = in.read();
               if ((c2 != '\n') && (c2 != -1)) {
                  if (!(in instanceof PushbackInputStream)) {
                     in = new PushbackInputStream(in);
                  }
                  ((PushbackInputStream)in).unread(c2);
                } else {
                  break loop;
                }

                default:
                   if (--bufferRemaining < 0) {
                      buf = new char[offset + 128];
                      bufferRemaining = buf.length - offset - 1;
                      System.arraycopy(lineBuffer, 0, buf, 0, offset);
                      Arrays.fill(lineBuffer, ' ');
                      lineBuffer = buf;
                   }
                   buf[offset++] = (char) c;
                   break;
         }
      }
      maskingthread.haltMasking();
      
      if (offset == 0) {
         return null;
      }
      char[] ret = new char[offset];
      System.arraycopy(buf, 0, ret, 0, offset);
      Arrays.fill(buf, ' ');
      return ret;
   }
}
