/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.IKeyInfo;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.IX509Data;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class KeyInfo implements IKeyInfo {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	Element _keyInfoElement = null;
	
	IX509Data _x509Data = null;
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}

	public IX509Data getX509Data() {
		return _x509Data;
	}

	public void setX509Data(IX509Data x509Data) {
		_x509Data = x509Data;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_keyInfoElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_keyInfoElement, 
				LocalElementNames.DS_KEY_INFO, 
				Constants.NSURI_DS_2000_09) || _keyInfoElement == null)
		{
			_keyInfoElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_DS_2000_09 + ":" + LocalElementNames.DS_KEY_INFO}));			
			
		}
		
		Element x509DataElement = XmlUtils.retrieveFirstChildMatchOfType(
				_keyInfoElement, 
				LocalElementNames.DS_X509_DATA, 
				Constants.NSURI_DS_2000_09);
		
		if (x509DataElement != null)
		{
			_x509Data = new X509Data();
			_x509Data.fromXml(x509DataElement);
			((X509Data)_x509Data).setParent(this);
		}

	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
