/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.exceptions.DuplicateCardIdException;
import org.eclipse.higgins.cardstore.schemas.XMLSerializer;

public interface IRoamingStore extends XMLSerializer {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	/**
	 * Returns a list of all the roaming information cards in the order
	 * they are stored.
	 * <p/>
	 * 
	 * @return an array of <code>IRoamingInformationCard</code>.
	 */
	public IRoamingInformationCard[] getRoamingInformationCards();
	
	/**
	 * This method will return the specific 
	 * @param id
	 * @return
	 */
	public IRoamingInformationCard getRoamingInformationCardByCardId(String id);

	/**
	 * Use this method to add information cards to the store. There can't be two cards
	 * with the same card id added to that store.
	 * 
	 * @param card
	 * @return if added successfully
	 * @throws DuplicateCardIdException
	 */
	public void addRoamingInformationCard(IRoamingInformationCard card) throws DuplicateCardIdException;
	
	/**
	 * Use this method to remove information cards from the store by their corresponding id.  If successfully
	 * removed the removed card is returned. If null is returned then there was no card by the given id in the store.
	 * 
	 * @param id
	 * @return the removed card.
	 */
	public IRoamingInformationCard removeRoamingInformationCardByCardId(String id);
	
}