/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2006._02.addressingidentity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.IKeyInfo;
import org.eclipse.higgins.cardstore.schemas._2000._09.xmldsig.impl.KeyInfo;
import org.eclipse.higgins.cardstore.schemas._2006._02.addressingidentity.IIdentity;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class Identity implements IIdentity {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _identityElement = null;
	
	private IKeyInfo _keyInfo = null;
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}		
	
	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_identityElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_identityElement, 
				LocalElementNames.ADDRESSINGIDENTITY_IDENTITY, 
				Constants.NSURI_ADDRESSINGIDENTITY_2006_02) || _identityElement == null)
		{
			_identityElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_ADDRESSINGIDENTITY_2006_02 + ":" + LocalElementNames.ADDRESSINGIDENTITY_IDENTITY}));			
			
		}
		
		Element keyInfoElement = XmlUtils.retrieveFirstChildMatchOfType(
				_identityElement, 
				LocalElementNames.DS_KEY_INFO, 
				Constants.NSURI_DS_2000_09);
		
		if (keyInfoElement != null)
		{
			_keyInfo = new KeyInfo();
			_keyInfo.fromXml(keyInfoElement);
			((KeyInfo)_keyInfo).setParent(this);
		}
	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

	public IKeyInfo getKeyInfo() {
		return _keyInfo;
	}

	public void setKeyInfo(IKeyInfo ki) {
		_keyInfo = ki;		
	}

}
