/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/ 
package org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl;

import org.eclipse.higgins.cardstore.Constants;
import org.eclipse.higgins.cardstore.LocalElementNames;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.resources.CardStoreMessages;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ICardImage;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.ILogoImage;
import org.eclipse.higgins.cardstore.utils.Base64Utility;
import org.eclipse.higgins.cardstore.utils.MessageHelper;
import org.eclipse.higgins.cardstore.utils.XmlUtils;
import org.w3c.dom.Element;

public class CardImage implements ICardImage {
	public static String copyright = Constants.FULL_COPYRIGHT;
	
	private Element _cardImageElement = null;
	
	private byte[] _value = null;
	private boolean _isMimeTypeSet = false;
	
	private ILogoImage _mimeType = null;
	
	Object _parentNode = null;
	
	public Object getParent()
	{
		return _parentNode;
	}
	
	public void setParent(Object parentNode)
	{
		_parentNode = parentNode;
	}	
	
	public ILogoImage getMimeType() {		
		return _mimeType;
	}

	public byte[] getValue() {
		return _value;
	}

	public boolean isSetMimeType() {
		return _isMimeTypeSet;
	}

	public void setMimeType(ILogoImage value) {
		_mimeType = value;
		_isMimeTypeSet = true;
	}

	public void setValue(byte[] value) {	
		_value = value;
	}

	public void unsetMimeType() {
		_mimeType = null;
		_isMimeTypeSet = false;
	}

	public void fromXml(Object obj) throws UnsupportedObjectModel,
			ExpectedObjectNotPresent {
		_cardImageElement = XmlUtils.retrieveElementFromObject(obj);
		
		if (!XmlUtils.isElementType(
				_cardImageElement, 
				LocalElementNames.IDENTITY_CARD_IMAGE, 
				Constants.NSURI_IDENTITY_2005_05) || _cardImageElement == null)
		{
			_cardImageElement = null;
			throw new ExpectedObjectNotPresent(
					MessageHelper.getMessage(
							CardStoreMessages.expected_object_not_present, 
							new Object[]{Constants.NSURI_IDENTITY_2005_05 + ":" + LocalElementNames.IDENTITY_CARD_IMAGE}));
		}

		String valueTextBase64encoded = XmlUtils.retrieveAllTextFromChildTextNodes(_cardImageElement);
		
		if (valueTextBase64encoded != null && valueTextBase64encoded.length() > 0)
		{
			setValue(Base64Utility.decode(valueTextBase64encoded));
		}
		
		String mimeTypeLiteral = _cardImageElement.getAttribute("MimeType");
		
		if (mimeTypeLiteral != null)
		{
			setMimeType(ILogoImage.getByLiteral(mimeTypeLiteral));
		}
	}

	public Object toXml() {
		// TODO Auto-generated method stub
		return null;
	}

}
