/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Patrick R Wardrop (IBM Corporation)
 *******************************************************************************/
package org.eclipse.higgins.cardstore.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

import javax.security.auth.callback.PasswordCallback;

import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.cardstore.CardStoreBuilderFactory;
import org.eclipse.higgins.cardstore.ICardStoreBuilder;
import org.eclipse.higgins.cardstore.exceptions.StoreEncryptionException;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IEncryptedStore;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingStore;
import org.w3c.dom.Element;

public class Tester {

    public static void main(String[] args) throws Exception {
	char[] passwd = new char[] { 'p', 'a', 's', 's', 'w', '0', 'r', 'd' };

	IRoamingStore mycards = readInStore("/home/bus/bas/empty.crds", passwd);

//	File roamingStoreXml = new File("/home/bus/bas/roamingStore.xml");
	File roamingStoreXml = new File("/home/bus/bas/cardmanagerExport230707Good.xml");
	StringBuffer xmlSz = new StringBuffer();
	try {
	    FileReader reader = new FileReader(roamingStoreXml);
	    int car;
	    while ((car = reader.read()) != -1) {
		xmlSz.append((char) car);
	    }
	    reader.close();
	} catch (Exception e) {
	    e.printStackTrace();
	}
	OMElement om0 = toOM(xmlSz.toString());

	Element element = toDOM(om0);

	mycards.fromXml(element);

	String out = "/home/bus/bas/new.crds";
	writeOutStore(mycards, out, passwd);
	System.out.println("Output file: " + out + " created.");
    }

    private static void writeOutStore(IRoamingStore store, String filename,
	    char[] passwd) throws StoreEncryptionException, IOException {
	ICardStoreBuilder builder = CardStoreBuilderFactory
		.newCardStoreBuilder();

	IEncryptedStore es = builder.createEncryptedStore();
	es.setRoamingStore(store);

	PasswordCallback pc = new PasswordCallback("What is your password: ",
		true);
	pc.setPassword(passwd);

	long timeStart = System.currentTimeMillis();
	byte[] esBytes = es.toXml(pc);
	long timeStop = System.currentTimeMillis();

	System.out.println("total time (encrypt): [" + filename + "]"
		+ (timeStop - timeStart));

	FileOutputStream fos = new FileOutputStream(new File(filename));
	fos.write(esBytes);
	fos.flush();
	fos.close();
    }

    private static IRoamingStore readInStore(String filename, char[] passwd)
	    throws Exception {
	ICardStoreBuilder builder = CardStoreBuilderFactory
		.newCardStoreBuilder();

	IEncryptedStore es = null;

	PasswordCallback pc = new PasswordCallback("What is your password: ",
		true);
	pc.setPassword(passwd);
	File crdsFile = new File(filename);
	byte[] crdsBytes = new byte[(int) crdsFile.length()];
	FileInputStream fis = new FileInputStream(crdsFile);
	fis.read(crdsBytes);

	long timeStart = System.currentTimeMillis();

	es = builder.createEncryptedStore(crdsBytes);
	IRoamingStore rs = es.getRoamingStore(pc);
	long timeStop = System.currentTimeMillis();

	System.out.println("total time (decrypt): [" + filename + "]"
		+ (timeStop - timeStart));

	return rs;
    }

    // public static void main(String[] args) throws Exception
    // {
    // char[] passwd = new char[]{'p','a','s','s','w','0','r','d'};
    //		
    // IRoamingStore mycards = readInStore("c:/temp/new_mycards.crds",
    // passwd);
    //		
    // if (mycards != null)
    // {
    // // Add a Card
    // //char[] passwd2 = new char[]{'i','b','m','i','b','m','i','b','m'};
    // // Read in a encryptedstore and take a card from it to add.
    // IRoamingStore tempstore = readInStore("c:/temp/new_tonycards.crds",
    // passwd);
    // String idToUse =
    // "https://xmldap.org/sts/card/064B2DDE-C40D-F42E-2FA1-35261F8DE82F";
    // IRoamingInformationCard card =
    // tempstore.getRoamingInformationCardByCardId(idToUse);
    //			
    // if (card != null)
    // {
    // mycards.addRoamingInformationCard(card);
    // }
    //			
    // if (tempstore.removeRoamingInformationCardByCardId(idToUse) == null)
    // {
    // System.err.println("The card WAS NOT removed.");
    // } else {
    // System.out.println("The card [" + idToUse + "] was removed." );
    // }
    //			
    // // write out to disk both stores
    // writeOutStore(mycards, "c:/temp/new_mycards.crds", passwd);
    // writeOutStore(tempstore, "c:/temp/new_tonycards.crds", passwd);
    // }
    //		
    // }
    //	
    // private static void writeOutStore(IRoamingStore store, String
    // filename, char[] passwd) throws StoreEncryptionException, IOException
    // {
    // ICardStoreBuilder builder =
    // CardStoreBuilderFactory.newCardStoreBuilder();
    //		
    // IEncryptedStore es = builder.createEncryptedStore();;
    // es.setRoamingStore(store);
    //		
    // PasswordCallback pc = new PasswordCallback("What is your password: ",
    // true);
    // pc.setPassword(passwd);
    //		
    // long timeStart = System.currentTimeMillis();
    // byte[] esBytes = es.toXml(pc);
    // long timeStop = System.currentTimeMillis();
    //		
    // System.out.println("total time (encrypt): [" + filename + "]" +
    // (timeStop - timeStart));
    //		
    // FileOutputStream fos = new FileOutputStream(new File(filename));
    // fos.write(esBytes);
    // fos.flush();
    // fos.close();
    // }
    //	
    // private static IRoamingStore readInStore(String filename, char[]
    // passwd) throws Exception
    // {
    // ICardStoreBuilder builder =
    // CardStoreBuilderFactory.newCardStoreBuilder();
    //		
    // IEncryptedStore es = null;
    //
    // PasswordCallback pc = new PasswordCallback("What is your password: ",
    // true);
    // pc.setPassword(passwd);
    // File crdsFile = new File(filename);
    // byte[] crdsBytes = new byte[(int)crdsFile.length()];
    // FileInputStream fis = new FileInputStream(crdsFile);
    // fis.read(crdsBytes);
    //		
    // long timeStart = System.currentTimeMillis();
    //		
    // es = builder.createEncryptedStore(crdsBytes);
    // IRoamingStore rs = es.getRoamingStore(pc);
    // long timeStop = System.currentTimeMillis();
    //		
    // System.out.println("total time (decrypt): [" + filename + "]" +
    // (timeStop - timeStart));
    //		
    // return rs;
    // }

    /**
         * Converts an OMElement to an equivalent DOM Element
         * 
         * @param omElement
         *                an OMElement to be converted into a DOM Element
         * @return the converted DOM Element
         */
    public static org.w3c.dom.Element toDOM(
	    org.apache.axiom.om.OMElement omElement) throws Exception {
	if (null == omElement)
	    return null;
	java.io.ByteArrayOutputStream outputStream = new java.io.ByteArrayOutputStream();
	try {
	    omElement.serialize(outputStream);
	} catch (Exception e) {
	    e.printStackTrace();
	}
	if (0 == outputStream.size()) {
	    return null;
	}
	java.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream(
		outputStream.toByteArray());
	javax.xml.parsers.DocumentBuilderFactory documentBuilderFactory = javax.xml.parsers.DocumentBuilderFactory
		.newInstance();
	documentBuilderFactory.setNamespaceAware(true);
	javax.xml.parsers.DocumentBuilder documentBuilder = documentBuilderFactory
		.newDocumentBuilder();
	org.w3c.dom.Document domDocument = documentBuilder.parse(inputStream);
	return domDocument.getDocumentElement();
    }

    public static org.apache.axiom.om.OMElement toOM(String strElement)
	    throws Exception {
	java.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream(
		strElement.getBytes());
	javax.xml.stream.XMLInputFactory xif = javax.xml.stream.XMLInputFactory
		.newInstance();
	javax.xml.stream.XMLStreamReader reader = xif
		.createXMLStreamReader(inputStream);
	org.apache.axiom.om.impl.builder.StAXOMBuilder builder = new org.apache.axiom.om.impl.builder.StAXOMBuilder(
		reader);
	return builder.getDocumentElement();
    }
}
