/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.securestorage;

import java.io.IOException;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class CardStorePersonalCard
extends PersonalCard {
    public CardStorePersonalCard() throws IOException, Exception {
        this.description_ = "CardStore CardSpace-interoperable managed I-Card";
        this.provider_ = null;
        this.isSelfIssued_ = true;
        this.issuer_ = ISSUER_SELF;
        this.issuerName_ = "Self";
    }

    public CardStorePersonalCard(CardStorePersonalCard card2copy) {
        this.description_ = card2copy.description_;
        this.provider_ = card2copy.provider_;
        this.isSelfIssued_ = card2copy.isSelfIssued_;
        this.issuer_ = card2copy.issuer_;
        this.issuerName_ = card2copy.issuerName_;
        this.id_ = card2copy.id_;
        this.name_ = card2copy.name_;
        this.masterKey_ = card2copy.masterKey_;
        this.image_ = card2copy.image_;
        this.imageMimeType_ = card2copy.imageMimeType_;
        this.timeLastUpdated_ = new Date();
    }

    public CardStorePersonalCard(ICardProvider provider, Element element) throws IOException, Exception {
        if (provider == null) {
            throw new IllegalArgumentException("Parameter \"provider\" is null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Parameter \"element\" is null");
        }
        this.description_ = "CardStore CardSpace-interoperable managed I-Card";
        this.provider_ = provider;
        super.initFromXML(element);
    }

    public void setIId(URI id) {
        this.id_ = id;
    }

    public void setVersion(String version) {
        this.version_ = version;
    }

    public void setClaimList(List claims) throws CardException {
        super.setClaims(claims);
    }

    public void setPinCode(IPinCodeCredential pinCodeCredential) throws CardException {
    }

    public void applyUpdates() throws InvalidStateException, CardException {
    }

    public void beginUpdates() throws InvalidStateException {
    }

    public void cancelUpdates() throws InvalidStateException {
    }

    public boolean isEditMode() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public void setImage(byte[] newImage, String newImageType) throws CardException {
        this.image_ = newImage;
        this.imageMimeType_ = newImageType;
    }

    public void setIssuerName(String name) throws CardException {
        this.issuerName_ = name;
    }

    public void setName(String newName) throws CardException {
        this.name_ = newName;
    }

    public void setTimeIssued(Date date) throws CardException {
        this.timeIssued_ = date;
    }

    public void setTimeExpires(Date date) throws CardException {
        this.timeExpires_ = date;
    }

    public void setTimeLastUpdate(Date date) throws CardException {
        this.timeLastUpdated_ = date;
    }

    public IClaim createClaim(String type) throws InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    public IClaim setClaim(IClaim copyFrom) throws InvalidClaimException, InvalidTypeException, ReadOnlyObjectException {
        throw new ReadOnlyObjectException();
    }

    protected void retrieveClaims(ICredential credential) throws AuthenticationRequiredException, AuthenticationException, CardException {
    }

    public void setPinCode(String pinCode) throws CardException {
    }

    public void setSupportedTokenTypeList(List supportedTokenTypes) {
        this.supportedTokenTypes_ = supportedTokenTypes;
    }

    public void setClaimsTypeList(List claimType) {
        this.claimTypes_ = claimType;
    }

    public void setMasterKey(byte[] key) {
        this.masterKey_ = key;
    }

    public Element toXML(Document doc) throws CardException {
        Element oldRoot = super.toXML(doc);
        Element newRoot = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RoamingInformationCard");
        NamedNodeMap attrs = oldRoot.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr2 = (Attr)doc.importNode(attrs.item(i), true);
            newRoot.getAttributes().setNamedItem(attr2);
        }
        Element metaData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
        while (oldRoot.hasChildNodes()) {
            metaData.appendChild(oldRoot.getFirstChild());
        }
        Element privateData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardPrivateData");
        Element masterKey = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "MasterKey");
        if (this.masterKey_ == null) {
            byte[] key = new byte[32];
            this.masterKey_ = SecureRandom.getSeed(32);
        }
        String base64Key = CardCryptography.encodeBase64((byte[])this.masterKey_, (int)0);
        masterKey.appendChild(doc.createTextNode(base64Key));
        privateData.appendChild(masterKey);
        Element claimValueList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValueList");
        Set setClaimValues = this.claimValues_.entrySet();
        Iterator values = setClaimValues.iterator();
        while (values.hasNext()) {
            Map.Entry meClaimValue = values.next();
            ClaimValue claim = (ClaimValue)meClaimValue.getValue();
            Element claimValue = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValue");
            claimValue.setAttribute("Uri", claim.getType().getType());
            Element value = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Value");
            value.appendChild(doc.createTextNode(claim.getValue()));
            claimValue.appendChild(value);
            claimValueList.appendChild(claimValue);
        }
        privateData.appendChild(claimValueList);
        newRoot.appendChild(metaData);
        newRoot.appendChild(privateData);
        oldRoot.getParentNode().replaceChild(newRoot, oldRoot);
        return newRoot;
    }

    private void addTokenServiceList(Document doc, Element informationCardMetaData) {
        Element tokenServiceList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenServiceList");
        informationCardMetaData.appendChild(tokenServiceList);
        Element tokenService = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenService");
        tokenServiceList.appendChild(tokenService);
        Element endpointReference = doc.createElementNS("http://www.w3.org/2005/08/addressing", "EndpointReference");
        tokenService.appendChild(endpointReference);
        Element address = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Address");
        XMLUtils.setTextContent((Element)address, (String)ISSUER_SELF);
        endpointReference.appendChild(address);
        Element metaData = doc.createElementNS("http://www.w3.org/2005/08/addressing", "MetaData");
        XMLUtils.setTextContent((Element)address, (String)ISSUER_SELF);
        endpointReference.appendChild(address);
    }
}

