/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.securestorage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cardstore.CardStoreBuilderFactory;
import org.eclipse.higgins.cardstore.ICardStoreBuilder;
import org.eclipse.higgins.cardstore.exceptions.DuplicateCardIdException;
import org.eclipse.higgins.cardstore.exceptions.ExpectedObjectNotPresent;
import org.eclipse.higgins.cardstore.exceptions.StoreDecryptionException;
import org.eclipse.higgins.cardstore.exceptions.StoreEncryptionException;
import org.eclipse.higgins.cardstore.exceptions.UnsupportedObjectModel;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IEncryptedStore;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IInformationCardMetaData;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingInformationCard;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.IRoamingStore;
import org.eclipse.higgins.cardstore.schemas._2005._05.identity.impl.RoamingStore;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.CardStoreException;
import org.eclipse.higgins.icard.CardStoreStrategy;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard;
import org.eclipse.higgins.icard.provider.securestorage.CardStoreManagedCard;
import org.eclipse.higgins.icard.provider.securestorage.CardStorePersonalCard;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SecureStorageStrategy
implements CardStoreStrategy {
    private static SecureRandom _randomGenerator = null;
    private boolean _initialized = false;
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageStrategy == null ? (class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageStrategy = SecureStorageStrategy.class$("org.eclipse.higgins.icard.provider.securestorage.SecureStorageStrategy")) : class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageStrategy));
    Element roamingDump;
    ICardStoreBuilder builder = null;
    PasswordCallback passwordCallback = null;
    String filename = null;
    private ICardProvider cardProvider;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$securestorage$SecureStorageStrategy;

    public SecureStorageStrategy() {
        this.log.debug((Object)"init SecureStorageStrategy");
        this.builder = CardStoreBuilderFactory.newCardStoreBuilder();
    }

    public void initialize(CallbackHandler authHandler, ICardProvider cardProvider, String filename, PasswordCallback passwordCallBack, IConfiguration configuration) throws CardStoreException {
        this.log.debug((Object)"SecureStrageStrategy:initialize");
        this.cardProvider = cardProvider;
        this.filename = filename;
        this.passwordCallback = passwordCallBack;
        this._initialized = true;
    }

    public void synchFromMap(CallbackHandler authHandler, Map icards) throws CardStoreException {
        Iterator icardIterator;
        String roamingId;
        IEncryptedStore es = this.getCurrentEncryptedStore();
        IRoamingStore roamingStore = this.getCurrentRoamingStore(es);
        IRoamingInformationCard[] roamingCards = roamingStore.getRoamingInformationCards();
        for (int i = 0; i < roamingCards.length; ++i) {
            IRoamingInformationCard roamingCard = roamingCards[i];
            roamingId = roamingCard.getInformationCardMetaData().getInformationCardReference().getCardId();
            icardIterator = icards.values().iterator();
            boolean found = false;
            while (icardIterator.hasNext()) {
                ICard card = (ICard)icardIterator.next();
                if (!card.getID().equals(roamingId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.log.info((Object)("deleting card from roaming store" + roamingId));
            roamingStore.removeRoamingInformationCardByCardId(roamingId);
        }
        icardIterator = icards.values().iterator();
        while (icardIterator.hasNext()) {
            ICard card = (ICard)icardIterator.next();
            boolean found = false;
            for (int i = 0; i < roamingCards.length; ++i) {
                IRoamingInformationCard roamingCard = roamingCards[i];
                roamingId = roamingCard.getInformationCardMetaData().getInformationCardReference().getCardId();
                if (!card.getID().equals(roamingId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.log.info((Object)("adding card from roaming store" + card.getID()));
            IRoamingInformationCard newCard = this.builder.createRoamingInformationCard();
            try {
                Element element = null;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.newDocument();
                if (card instanceof ManagedCard) {
                    element = ((ManagedCard)card).toXML(doc);
                } else if (card instanceof PersonalCard) {
                    element = ((PersonalCard)card).toXML(doc);
                }
                this.log.info((Object)("element=[" + element.getNodeName() + "]"));
                this.log.info((Object)("element.nms=[" + element.getNamespaceURI() + "]"));
                newCard.fromXml(element);
                this.log.info((Object)("newCard.informationCardMetaDada=[" + newCard.getInformationCardMetaData() + "]"));
            }
            catch (Exception e) {
                this.log.error((Object)"Convertion from InformationCard to Roaming.informationCardMetaData failed", (Throwable)e);
            }
            try {
                roamingStore.addRoamingInformationCard(newCard);
            }
            catch (DuplicateCardIdException e) {
                this.log.error((Object)("Error when add card(" + newCard.getInformationCardMetaData().getInformationCardReference().getCardId() + ")"));
            }
            this.log.info((Object)("added card to roaming store [" + newCard.getInformationCardMetaData().getInformationCardReference().getCardId() + "]"));
        }
        try {
            this.saveRoamingStore(roamingStore, es);
        }
        catch (StoreEncryptionException e) {
            throw new CardStoreException("Error when Encrypting the roaming store", (Throwable)e);
        }
        catch (IOException e) {
            throw new CardStoreException("Error when saving the roaming store", (Throwable)e);
        }
    }

    public void synchFromStore(CallbackHandler authHandler, Map icards) throws CardStoreException {
        IRoamingStore rs;
        IEncryptedStore es;
        if (!this._initialized) {
            throw new CardStoreException("Not initialized.");
        }
        ICardStoreBuilder builder = CardStoreBuilderFactory.newCardStoreBuilder();
        this.log.info((Object)("Reading SecureStore [" + this.filename + "]"));
        File crdsFile = new File(this.filename);
        byte[] crdsBytes = new byte[(int)crdsFile.length()];
        try {
            FileInputStream fis = new FileInputStream(crdsFile);
            fis.read(crdsBytes);
            fis.close();
        }
        catch (FileNotFoundException fe) {
            throw new CardStoreException((Throwable)fe);
        }
        catch (IOException ioe) {
            throw new CardStoreException((Throwable)ioe);
        }
        try {
            es = builder.createEncryptedStore(crdsBytes);
        }
        catch (UnsupportedObjectModel e) {
            throw new CardStoreException((Throwable)e);
        }
        catch (ExpectedObjectNotPresent e) {
            throw new CardStoreException((Throwable)e);
        }
        try {
            this.log.info((Object)("Decrypting SecureStorage [" + this.filename + ":" + String.valueOf(this.passwordCallback.getPassword()) + " passwordCallback=" + this.passwordCallback + "]"));
            rs = es.getRoamingStore(this.passwordCallback);
            this.log.info((Object)("Decrypted SecureStorage [" + this.filename + ":" + String.valueOf(this.passwordCallback.getPassword()) + " passwordCallback=" + this.passwordCallback + "]"));
            this.roamingDump = (Element)rs.toXml();
        }
        catch (StoreDecryptionException e) {
            this.log.error((Object)("Error when Decrypting SecureStorage [" + this.filename + ":" + String.valueOf(this.passwordCallback.getPassword()) + " passwordCallback=" + this.passwordCallback + "]"));
            throw new CardStoreException((Throwable)e);
        }
        this.syncFromStore(rs, icards);
    }

    public void newStorage() throws CardStoreException, IOException {
        this.log.debug((Object)("create new store [" + this.filename + "]"));
        IEncryptedStore es = this.builder.createEncryptedStore();
        RoamingStore roamingStore = new RoamingStore();
        try {
            this.saveRoamingStore(roamingStore, es);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardStoreException((Throwable)e);
        }
        this.log.debug((Object)("new store created [" + this.filename + "]"));
    }

    protected IEncryptedStore getCurrentEncryptedStore() throws CardStoreException {
        ICardStoreBuilder builder = CardStoreBuilderFactory.newCardStoreBuilder();
        IEncryptedStore es = null;
        this.log.info((Object)("Reading SecureStore [" + this.filename + "]"));
        File crdsFile = new File(this.filename);
        byte[] crdsBytes = new byte[(int)crdsFile.length()];
        try {
            if (!crdsFile.exists()) {
                crdsFile.createNewFile();
            }
            FileInputStream fis = new FileInputStream(crdsFile);
            fis.read(crdsBytes);
            fis.close();
        }
        catch (FileNotFoundException fe) {
            throw new CardStoreException((Throwable)fe);
        }
        catch (IOException ioe) {
            throw new CardStoreException((Throwable)ioe);
        }
        if (crdsBytes == null) {
            crdsBytes = new byte[]{};
        }
        try {
            es = builder.createEncryptedStore(crdsBytes);
        }
        catch (Exception e) {
            throw new CardStoreException((Throwable)e);
        }
        return es;
    }

    protected IRoamingStore getCurrentRoamingStore(IEncryptedStore es) throws CardStoreException {
        IRoamingStore roamingStore = null;
        try {
            roamingStore = es.getRoamingStore(this.passwordCallback);
        }
        catch (Exception e) {
            throw new CardStoreException((Throwable)e);
        }
        return roamingStore;
    }

    private void saveRoamingStore(IRoamingStore roamingStore, IEncryptedStore es) throws StoreEncryptionException, IOException {
        this.roamingDump = (Element)roamingStore.toXml();
        es.setRoamingStore(roamingStore);
        byte[] blob = es.toXml(this.passwordCallback);
        FileOutputStream fos = new FileOutputStream(this.filename);
        fos.write(blob);
        fos.close();
        this.log.info((Object)("saving cardstore in [" + this.filename + "]"));
    }

    protected void backupCRDS() throws CardStoreException {
        this.log.trace((Object)("backupCRDS(" + this.filename + ")"));
        File cardStore = new File(this.filename);
        File backupStore = new File(this.filename + ".bak");
        if (!cardStore.canRead()) {
            throw new CardStoreException("Cannot read CardStore. Filename=" + this.filename);
        }
        if (backupStore.exists() && !backupStore.delete()) {
            throw new CardStoreException("Could not delete CardStoreBackup file.");
        }
        cardStore.renameTo(backupStore);
    }

    private static void generateRandomBytes(byte[] b) throws NoSuchAlgorithmException {
        if (b == null) {
            return;
        }
        if (_randomGenerator == null) {
            _randomGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        _randomGenerator.nextBytes(b);
    }

    protected void syncFromStore(IRoamingStore rs, Map icards) throws CardStoreException {
        this.log.info((Object)("SyncFromStore: filename=" + this.filename));
        IRoamingInformationCard[] cards = rs.getRoamingInformationCards();
        icards.clear();
        if (cards == null) {
            throw new CardStoreException("getRoamingInformationCards() returned null");
        }
        for (int i = 0; i < cards.length; ++i) {
            try {
                IRoamingInformationCard storageCard = cards[i];
                Object translatedCard = null;
                IInformationCardMetaData iCardMetadata = storageCard.getInformationCardMetaData();
                boolean selfIssued = iCardMetadata.isIsSelfIssued();
                this.log.info((Object)("Card[" + iCardMetadata.getCardName() + "] isselfIssued:" + selfIssued));
                if (this.log.isTraceEnabled()) {
                    Object objCardMetadata = iCardMetadata.toXml();
                    Element elemCardMetadata = (Element)objCardMetadata;
                    String informationCardSz = XMLHelper.toString((Element)elemCardMetadata);
                    this.log.debug((Object)("informationCardSz=[\n" + informationCardSz + "\n]"));
                }
                Element cardElement = (Element)storageCard.toXml();
                translatedCard = selfIssued ? new CardStorePersonalCard(this.cardProvider, cardElement) : new CardStoreManagedCard(this.cardProvider, cardElement);
                if (translatedCard == null) continue;
                this.log.trace((Object)("adding card:" + i));
                icards.put(translatedCard.getID(), translatedCard);
                continue;
            }
            catch (Error err) {
                System.err.println(err.getLocalizedMessage());
                err.printStackTrace();
                Throwable t = err.getCause();
                if (null != t) {
                    System.err.println(t.getLocalizedMessage());
                    t.printStackTrace();
                }
                throw new CardStoreException((Throwable)err);
            }
            catch (Exception e) {
                this.log.error((Object)"Error when transforming secure cardspace into higgins card", (Throwable)e);
                throw new CardStoreException((Throwable)e);
            }
        }
    }

    public void exportCards(CallbackHandler authHandler, Iterator cards, OutputStream out) throws CardException {
        throw new CardException("Operation not supported");
    }

    public boolean isPasswordProtected() {
        return true;
    }

    public void changePassword(char[] oldPassword, char[] newPassword) throws CardStoreException {
        String oldPasswd1;
        String oldPasswd = String.valueOf(oldPassword);
        if (!oldPasswd.equals(oldPasswd1 = String.valueOf(oldPassword))) {
            throw new CardStoreException("Provided old password not correct");
        }
        IEncryptedStore es = this.getCurrentEncryptedStore();
        IRoamingStore roamingStore = this.getCurrentRoamingStore(es);
        try {
            this.passwordCallback.setPassword(newPassword);
            this.saveRoamingStore(roamingStore, es);
        }
        catch (StoreEncryptionException e) {
            throw new CardStoreException("Error when Encrypting the roaming store", (Throwable)e);
        }
        catch (IOException e) {
            throw new CardStoreException("Error when saving the roaming store", (Throwable)e);
        }
    }

    public Element getRoamingDump() {
        return this.roamingDump;
    }

    public Map importStore(CallbackHandler authHandler, String asciiStore) throws CardStoreException {
        this.log.debug((Object)("import store [" + this.filename + "]"));
        RoamingStore roamingStore = new RoamingStore();
        try {
            OMElement om0 = XMLHelper.toOM((String)asciiStore);
            Element element = XMLHelper.toDOM((OMElement)om0);
            roamingStore.fromXml(element);
            HashMap icards = new HashMap();
            this.syncFromStore(roamingStore, icards);
            return icards;
        }
        catch (Exception e) {
            this.log.error((Object)"Error when importing an ASCII Store", (Throwable)e);
            throw new CardStoreException("Error when importing an ASCII Store", (Throwable)e);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setPasswordCallback(PasswordCallback passwordCallback) {
        if (passwordCallback != null) {
            this.passwordCallback = passwordCallback;
            this._initialized = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

