/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.registry;

import java.io.File;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.io.IFormatProvider;
import org.eclipse.higgins.registry.HigginsRegistry;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.registry.IRegistryExtension;
import org.eclipse.higgins.registry.IServiceProvider;
import org.eclipse.higgins.registry.PropertiesConfigurationFactory;
import org.eclipse.higgins.registry.RegistryConfigurationException;
import org.eclipse.higgins.registry.SecurityRegistryExtension;
import org.eclipse.higgins.registry.IIORegistryExtension;

public class IOFormatRegistry extends HigginsRegistry {

	private static Log log = LogFactory.getLog(IOFormatRegistry.class);

	protected static IOFormatRegistry instance = null;

	protected static PropertiesConfigurationFactory configFactory = new PropertiesConfigurationFactory(".icard"
			+ File.pathSeparator + ".io");

	/**
	 * Set up the valid service provider categories and automatically register
	 * all available service providers.
	 * 
	 * <p>
	 * The constructor is protected in order to prevent creation of additional
	 * instances.
	 */
	protected IOFormatRegistry() {
		super(IFormatProvider.class);
		initialize();
	}

	/**
	 * @param configPath
	 */
	// public IOFormatRegistry(String configPath) {
	// super(IFormatProvider.class, configPath);
	// initialize();
	// }
	private void initialize() {
		addExtension(HCExtensionHelper.getHCExtension());
		addExtension(new IIORegistryExtension(IFormatProvider.class));
		addExtension(new SecurityRegistryExtension(IFormatProvider.class));
		try {
			Class c = Class.forName("org.eclipse.higgins.icard.registry.plugin.ICardIORegistryExtension");
			IRegistryExtension e = (IRegistryExtension) c.newInstance();
			addExtension(e);
		} catch (ClassNotFoundException e) {
		} catch (Throwable e) {
			log.error(e, e);
		}
		loadProviders();
	}

	public Iterator getFormatProviders() {
		return getServiceProviders();
	}

	public IFormatProvider getFormatProvider(String extID) {
		if (extID == null) {
			throw new IllegalArgumentException("id == null!");
		}
		return (IFormatProvider) getServiceProvider(extID);
	}

	public synchronized static IOFormatRegistry getInstance() {
		if (instance == null) {
			instance = new IOFormatRegistry();
		}
		return instance;
	}

	public IConfiguration getConfiguration(IServiceProvider provider) throws RegistryConfigurationException {
		return configFactory.getConfigurqation(provider.getID());
	}
}
