package org.eclipse.higgins.icard.registry;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.registry.HCRegistryExtension;
import org.eclipse.higgins.registry.RegistryConfigurationException;

public class HCExtensionHelper {
	private static Log log = LogFactory.getLog(HCExtensionHelper.class);

	public final static String HC_REGISTRY_EXTENSION = "RegistryExtension";

	private static Map getConfig() throws Exception {
		String configurationBase = System.getProperty("org.eclipse.higgins.sts.conf");
		if (null == configurationBase) {
			configurationBase = ".\\";
		}
		String configurationFile = System.getProperty("org.eclipse.higgins.registry.conf.file");
		if (configurationFile == null)
			configurationFile = "ProvidersConfiguration.xml";
		ConfigurationHandler configurationHandler = new ConfigurationHandler();
		configurationHandler.setConfigurationBase(configurationBase);
		configurationHandler.setFileName(configurationFile);
		boolean isInitialized = configurationHandler.configure(null);
		if (!isInitialized) {
			throw new RegistryConfigurationException("Could not configure icard regisry");
		}
		return configurationHandler.getSettings();
	}

	public static HCRegistryExtension getHCExtension() {
		try {
			Map coonfig = getConfig();
			if (coonfig.containsKey(HC_REGISTRY_EXTENSION)) {
				return (HCRegistryExtension) coonfig.get(HC_REGISTRY_EXTENSION);
			} else {
				log.warn("Configuration does not contain setting : " + HC_REGISTRY_EXTENSION);
			}
		} catch (Exception e) {
			log.warn(e, e);
		}
		return null;
	}
}
