/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.registry.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class DataUtils {
	private static final int BUFFER_SIZE = 4096;

	public static final byte[] readBytes(InputStream is) throws IOException {
		ByteArrayOutputStream bos = new ByteArrayOutputStream(is.available());
		copy(is,bos);
		is.close();
		return bos.toByteArray();
	}

	public static final void copyAndClose(InputStream in, OutputStream out) throws IOException {
		try {
			copy(in, out);
		} finally {
			try {
				in.close();
			} catch (Exception e) {
			}
			try {
				out.close();
			} catch (Exception e) {
			}
		}
	}

	public static final void copy(InputStream in, OutputStream out) throws IOException {
		copy(in,out,BUFFER_SIZE);
	}

	public static final void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
		byte[] buffer = new byte[bufferSize];
		int read;
		while (true) {
			read = in.read(buffer);
			if (read == -1) break;
			out.write(buffer,0,read);
		}
		return;
	}

	public static final void copy(Reader in, Writer out) throws IOException {
		copy(in,out,BUFFER_SIZE);
	}

	public static final void copy(Reader in, Writer out, int bufferSize) throws IOException {
		char[] buffer = new char[bufferSize];
		int read;
		while (true) {
			read = in.read(buffer);
			if (read == -1) break;
			out.write(buffer,0,read);
		}
		return;
	}
}
