/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.registry.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class DataUtils {
    private static final int BUFFER_SIZE = 4096;

    public static final byte[] readBytes(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(is.available());
        DataUtils.copy(is, bos);
        is.close();
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void copyAndClose(InputStream in, OutputStream out) throws IOException {
        try {
            DataUtils.copy(in, out);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        try {}
        catch (Exception exception) {}
        in.close();
        try {}
        catch (Exception exception) {
            return;
        }
        out.close();
    }

    public static final void copy(InputStream in, OutputStream out) throws IOException {
        DataUtils.copy(in, out, 4096);
    }

    public static final void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int read;
        byte[] buffer = new byte[bufferSize];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    public static final void copy(Reader in, Writer out) throws IOException {
        DataUtils.copy(in, out, 4096);
    }

    public static final void copy(Reader in, Writer out, int bufferSize) throws IOException {
        int read;
        char[] buffer = new char[bufferSize];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }
}

