/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;

import java.util.EventObject;

/**
 * Defines an event class for changing of an
 * <code>IInformationCardExtension</code>
 * 
 */
public class ICardExtensionEvent extends EventObject {

	private static final long serialVersionUID = -1417922698118021538L;

	private IInformationCardExtension extension;

	/**
	 * @param source
	 */
	public ICardExtensionEvent(IInformationCardExtension source) {
		super(source);
		extension = source;
	}

	/**
	 * @return
	 */
	public IInformationCardExtension getExtension() {
		return extension;
	}

}
