/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;

import java.util.Iterator;

/**
 * The <code>IClaimTypeContainer</code> interface defines a container
 * intarface for {@link IClaimType} objects. Represents a model of
 * an {@link IClaimContainer} containers.
 */
public interface IClaimTypeContainer {
	/**
	 * Return a list of {@link IClaimType}s which describes a set of {@link IClaim}s that are
	 * supported by some {@link IClaimContainer}.
	 * 
	 * @see IClaim
	 * @see IClaimType
	 * @see IClaimContainer
	 */
	public Iterator getSupportedClaimTypes();
}
