/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard;

import java.util.Iterator;

/**
 * Used to collect <code>ITemplateElement</code> elements into some logical
 * group
 */
public interface ITemplateContainer extends ITemplateElement {

	/**
	 * Add <code>ITemplateElement</code> to this container
	 * 
	 * @param element
	 */
	public void addTemplateElement(ITemplateElement element);

	/**
	 * Remove <code>ITemplateElement</code> from this container
	 * 
	 * @param element
	 */
	public void removeTemplateElement(ITemplateElement element);

	/**
	 * @return <code>Iterator</code> of <code>ITemplateElement</code> which
	 *         this container owns directly
	 */
	public Iterator getTemplateElements();

	/**
	 * @param id
	 *            ID of required <code>ITemplateElement</code>
	 * @return <code>ITemplateElement</code> which this container owns
	 *         directly
	 */
	public ITemplateElement getTemplateElementByID(String id);

	/**
	 * @param id
	 *            ID of required <code>ITemplateValue</code>
	 * @return <code>ITemplateValue</code> which this container owns directly
	 */
	public ITemplateValue getTemplateValueByID(String id);

}
