/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.io;

import java.io.InputStream;

import org.eclipse.higgins.icard.auth.ICredential;

public interface IInputProcessor {
	/**
	 * Checks whether this <code>IInputProcessor</code> can process the input
	 * stream.
	 * 
	 * @return the information about input stream data format if it could be
	 *         processed by this <code>IInputProcessor</code> and
	 *         <code>null</code> otherwise.
	 * @throws CardIOException
	 */
	public IFormatDescriptor checkInput(InputStream is) throws CardIOException;

	/**
	 * Processes input stream and returns an array of <code>IElement</code>s
	 * extracted.
	 * @throws CardIOException TODO
	 */
	public IElement[] process(InputStream is, ICredential credential) throws CardIOException;
}
