/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;

import java.io.Serializable;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CUID implements Serializable{
	
	private static Log log = LogFactory.getLog(CUID.class);
	
	protected String providerID;
	protected String issuer;
	protected String cardID;

	public CUID(String str) throws CardException {
		StringTokenizer t = new StringTokenizer(str, "#");
		if (t.countTokens() != 3) {
			throw new CardException("Invalid string representationformat of CUID: str=\"" + str + "\"");
		}
		providerID = t.nextToken();
		issuer = t.nextToken();
		cardID = t.nextToken();
	}

	public CUID(final String providerID, final String issuer, final String cardID) {
		this.providerID = providerID;
		this.issuer = issuer;
		this.cardID = cardID;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof CUID) {
			CUID c = (CUID) obj;
			return (this.providerID == null ? c.providerID == null : this.providerID.equals(c.providerID))
					&& (this.issuer == null ? c.issuer == null : this.issuer.equals(c.issuer))
					&& (this.cardID == null ? c.cardID == null : this.cardID.equals(c.cardID));
		} else if (obj instanceof String) {
			CUID c = null;
			try {
				c = new CUID((String) obj);
			} catch (Exception e) {
				log.error(e,e);
				return false;
			}
			return equals(c);
		}
		return false;
	}

	/**
	 * @return the cardID
	 */
	public String getCardID() {
		return cardID;
	}

	/**
	 * @return the issuer
	 */
	public String getIssuer() {
		return issuer;
	}

	/**
	 * @return the providerID
	 */
	public String getProviderID() {
		return providerID;
	}

	/**
	 * @return
	 * @see java.lang.String#hashCode()
	 */
	public int hashCode() {
		return (this.providerID == null ? 3 : this.providerID.hashCode()) * (this.issuer == null ? 5 : this.issuer.hashCode())
				* ((this.cardID == null) ? 7 : this.cardID.hashCode());
	}

	/**
	 * @param cardID the cardID to set
	 */
	public void setCardID(String cardID) {
		this.cardID = cardID;
	}

	/**
	 * @param issuer the issuer to set
	 */
	public void setIssuer(String issuer) {
		this.issuer = issuer;
	}

	/**
	 * @param providerID the providerID to set
	 */
	public void setProviderID(String providerID) {
		this.providerID = providerID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return providerID + "#" + issuer + "#" + cardID;
	}
}
