/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard;

import java.util.List;

import org.eclipse.higgins.icard.policy.ISTSPrivacyPolicy;

/**
 * Represents managed CardSpace-interoperable I-Card
 */
public interface IManagedInformationCard extends IInformationCard {

	/**
	 * An ordered list of security token services
	 */
	public List getTokenServices();

	/**
	 * Indicates how RST must provide information identifying the relying
	 * party.
	 *  <code>null</code> - the token requester MUST NOT submit any token scope information.
	 *  <code>true</code> - the token scope information is not mandatory, but will be accepted by the Identity Provider if submitted.
	 *  <code>false</code> - the token scope information is mandatory.
	 */
	public Boolean getRequireAppliesTo();

	/**
	 * Privacy notice of STS
	 */
	public ISTSPrivacyPolicy getPrivacyNotice();

	/**
	 * Represents /ic07:RequireStrongRecipientIdentity extension element
	 * 
	 * @return If <code>true</code> than Selector MUST only allow the card to
	 *         be used at a Relying Party that presents a cryptographically
	 *         protected identity X.509v3 certificate.
	 */
	public boolean isStrongRecipientIdentityRequired();

	/**
	 * Represents /ic07:IssuerInformation extension element
	 * 
	 * @return Information from the card issuer about the card that can be
	 *         displayed by the Identity Selector user interface, may be null.
	 */
	public IIssuerInformationEntry[] getIc07IssuerInformation();

}
