/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 *     Valery Kokhan - move UI information to IUIDescriptor
 */

package org.eclipse.higgins.icard;


/**
 * Represents user's input data
 */
public interface ITemplateValue extends ITemplateElement {

	/**
	 * The string representing the data. Can contain default value
	 */
	public String getValue();

	/**
	 * @param value
	 */
	public void setValue(String value);

	/**
	 * Indicates that not-empty value is required
	 */
	public boolean isValueRequired();

	/**
	 * @param isValueRequired
	 *            <code>true</code> - not-empty value is required
	 *            <code>false</code> - value is not required
	 */
	public void setIsValueRequired(boolean isValueRequired);

	/**
	 * Gets an UI descriptor which provides an information how to display this
	 * template value.
	 */
	public IUIDescriptor getUIDescriptor();
	
	/**
	 * Sets an UI descriptor for this template value.
	 */
	public void setUIDescriptor(IUIDescriptor descriptor);
}
