/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;

import java.util.List;

public interface IUIDescriptor {

	/**
	 * TextField GUI component type
	 */
	public static final int TYPE_TEXTFILED = 0;
	
	/**
	 * TextArea GUI component type
	 */
	public static final int TYPE_TEXTAREA = 1;
	
	/**
	 * FileChooser GUI component type
	 */
	public static final int TYPE_FILE = 2;
	
	/**
	 * CheckField GUI component type
	 */
	public static final int TYPE_CHECKBOX = 3;
	
	/**
	 * ComboBox GUI component type
	 */
	public static final int TYPE_COMBOBOX = 4;

	/**
	 * Date(time) GUI component type 
	 */
	public static final int TYPE_DATETIME = 5;

	/**
	 * The type of value. Indicates which GUI component should be used to edit
	 * data of this value <code>TYPE_TEXTFILED</code> - element contains
	 * <code>String</code> type value which should be edited in text field
	 * <code>TYPE_TEXTAREA</code> - element contains <code>String</code>
	 * value which should be edited in text area <code>TYPE_FILE</code> -
	 * element contains base64-encoded bytes array of file
	 * <code>TYPE_CHECKBOX</code> 
	 * 	<code>TYPE_COMBOBOX</code>
	 */
	public int getType();

	/**
	 * Regular expressions pattern which should be used to validate user's input
	 * (returns <code>null</code> if validation is not required).
	 */
	public String getPattern();

	/**
	 * @param pattern
	 *            Regular expressions pattern which should be used to validate
	 *            user's input.
	 */
	public void setPattern(String pattern);

	/**
	 * @return
	 */
	public String getInputMask();

	/**
	 * @param inputMask
	 */
	public void setInputMask(String inputMask);

	/**
	 * Contains optional <code>String</code> values list in case of
	 * <code>TYPE_CHECKBOX</code> and <code>TYPE_COMBOBOX</code>.
	 */
	public List getOptionalValues();

	/**
	 * Sets the list of optional <code>String</code> values in case of
	 * <code>TYPE_CHECKBOX</code> and <code>TYPE_COMBOBOX</code>.
	 */
	public void setOptionalValues(List values);

}
