package org.eclipse.higgins.icard.io;


/**
 * This interface and its sub-interfaces provides an information about
 * input/output element format.
 */
public interface IElementFormat {
	
	/**
	 * Constant representing XML format of <code>IElement</code>s.
	 */
	public static final String XML_ELEMENT_FORMAT = "XML";
	
	/**
	 * Constant representing binary format of <code>IElement</code>s.
	 */
	public static final String BINARY_ELEMENT_FORMAT = "BINARY";
	
	/**
	 * Returns string id of data format used by <code>IElement</code>s at
	 * input/output operations.
	 */
	public String getFormatID();
}
