package org.eclipse.higgins.icard.policy;

import org.eclipse.higgins.icard.io.IElement;

/**
 * Interface represents STS privacy policy element of managed card
 * 
 */
public interface ISTSPrivacyPolicy {

	/**
	 * @return Privacy policy element
	 */
	public IElement getPrivacyElement();

	/**
	 * This parameter specifies the URL of the human-readable privacy policy of
	 * the site, if provided.
	 */
	public String getPrivacyUrl();

	/**
	 * This parameter specifies the privacy policy version. This must be a value
	 * greater than 0 if a privacyUrl is specified. If this value changes, the
	 * UI notifies the user and allows them review the change to the privacy
	 * policy.
	 */
	public String getPrivacyVersion();

}