/*******************************************************************************
 * Copyright (c) 2009 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

import java.io.Serializable;

/**
 * Authentication Materials are used to open an IContext.
 * The type of Authentication Materials which a context requires
 * can be discovered from a UDI via UDI Resolution
 * 
 * @see http://wiki.eclipse.org/Authentication_Materials
 * @see http://www.parity.com/udi
 */
public interface IAuthNMaterials extends Serializable {

	public static final String AUTHNMATERIALS_TYPE_ANONYMOUS = "urn:udi:authnmaterials:1.0:anonymous";
	public static final String AUTHNMATERIALS_TYPE_LEASTPRIVILEGED = "urn:udi:authnmaterials:1.0:leastPrivileged";
	public static final String AUTHNMATERIALS_TYPE_IMPLIED = "urn:udi:authnmaterials:1.0:implied";
	public static final String AUTHNMATERIALS_TYPE_USERNAMEPASSWORD = "urn:udi:authnmaterials:1.0:usernamePassword";
	public static final String AUTHNMATERIALS_TYPE_NAMEPRIVATEKEY = "urn:udi:authnmaterials:1.0:namePrivatekey";
	public static final String AUTHNMATERIALS_TYPE_PINFOCARD = "urn:udi:authnmaterials:1.0:p-infocard";
	public static final String AUTHNMATERIALS_TYPE_MINFOCARD = "urn:udi:authnmaterials:1.0:m-infocard";
	public static final String AUTHNMATERIALS_TYPE_SAMLPOLICY = "urn:udi:authnmaterials:1.0:samlpolicy";
}