/*******************************************************************************
 * Copyright (c) 2006-2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interfaces agreed upon 20060707
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import org.eclipse.higgins.idas.api.model.IEntityModel;

/**
 * As defined at 
 * <a href="http://wiki.eclipse.org/Entity">http://wiki.eclipse.org/Entity</a> 
 * and <a href="http://wiki.eclipse.org/Context">http://wiki.eclipse.org/Context</a>, 
 * This interface holds a set of {@link IEntity} objects.<p>
 * All Entities follow the http://www.eclipse.org/higgins/ontologies/2008/6/higgins ontology
 * as a base.
 * TODO (Doc): Finish javadoc on methods   
 */
public interface IEntity extends IValue
{

	/**
	 * Returns a model of this type of Entities as it defined in the
	 * context's schema. Returned model could be used to discover what
	 * attributes are defined in the context's schema for this type of Entities.
	 * 
	 * @return the model of this Entity
	 */
	public IEntityModel getModel();


	/**
	 * @return The Context holding this Entity.
	 * @throws IdASException
	 */
	public IContext getContext() throws IdASException;

	/**
	 * @return Contextually unique identifier of this Entity
	 * @throws IdASException
	 */
	public String getEntityID() throws IdASException;

	/**
	 * Indicates whether the entity belongs to this context or is just a reference to an entity from another context. 
	 * If entity is a reference, its type is null and it does not contain any attribute.    
	 * @return <code>true</code> if this is a reference, <code>false</code> otherwise. 
	 * @throws IdASException
	 */
	public boolean isProxy() throws IdASException;
	
}
