/*******************************************************************************
 * Copyright (c) 2006-2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.net.URI;

import org.eclipse.higgins.idas.api.model.IValueModel;
/**
 * Holds the value of a context.<p>
 * This interface is not intended to be instantiated (only used as a super-interface).
 * When the value is a Literal ({@link #isSimple()} returns true), an instance of this interface may be cast to {@link ISimpleAttrValue}, and the table found at {@link ITypedValue#getData()} is used to determine the type returned from {@link ITypedValue#getData()}.    
 * When the value is a Resource ({@link #isSimple()} returns false), an instance of this interface may be cast to {@link IComplexAttrValue}.<p>    
 * This extends {@link IHasAttributes} so that metadata about the attribute may be presented as 
 * attributes on this attribute.
 */
public interface IValue extends IHasAttributes {
	/**
	 * Value: {@value}
	 */
	public static final String BASE_OWL_URI = "http://www.eclipse.org/higgins/ontologies/2008/6/higgins#"; 

	/**
	 * @throws IdASException
	 */
	public boolean isSimple() throws IdASException;

	/**
	 * Returns this value's type (like string, int, address)
	 * This is a shortcut for calling getModel().getType().
	 * TODO (Doc): refer to an example like those found at <a href="http://wiki.eclipse.org/index.php/Person-with-address_Example_Context_Ontology">http://wiki.eclipse.org/index.php/Person-with-address_Example_Context_Ontology</a>
	 * @return The OWL type for this attribute's value (i.e. http://www.w3.org/2001/XMLSchema/string or http://www.eclipse.org/higgins/ontologies/2008/6/higgins#RelativeEntityUDI).
	 * @throws IdASException
	 */
	public URI getType() throws IdASException; 

	/**
	 * Removes this value from its container
	 * Note: This operation is only applied to any backing data store after
	 * IContext.applyUpdates() is called.
	 * @throws {@link IdASException}
	 */
	public void remove() throws IdASException;
	
	public IValueModel getValueModel();

}
