/*******************************************************************************
 * Copyright (c) 2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

/**
 * Thrown in cases where an attribute's model specifies that the attribute may hold
 * multiple values and the caller expects the attribute to be restricted to a 
 * single value (and thus castable to {@link ISingleValuedAttribute}.
 * This is not the same case as where an attribute is expected to have a single 
 * value but doesn't. For that case, see {@link MultipleValuesExistException}.
 */
public class NotSingleValuedAttributeException extends IdASException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7710622613288281762L;

	/**
	 * 
	 */
	public NotSingleValuedAttributeException() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param message
	 */
	public NotSingleValuedAttributeException(String message) {
		super(message);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param message
	 * @param cause
	 */
	public NotSingleValuedAttributeException(String message, Throwable cause) {
		super(message, cause);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param cause
	 */
	public NotSingleValuedAttributeException(Throwable cause) {
		super(cause);
		// TODO Auto-generated constructor stub
	}

}
