/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * Copyright (c) 2007-2008 Novell, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *     Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.net.URI;
import java.util.List;

import org.eclipse.higgins.idas.api.IHasAttributes;

/**
 * Represents a model of attribute as it defined in the context's ontology
 * model.
 * <p>
 * The type returned by
 * {@link org.eclipse.higgins.idas.api.model.IModel#getType()} could be used in
 * {@link IHasAttributes#addAttribute(URI)} to create an
 * {@link org.eclipse.higgins.idas.api.IAttribute} of represented type.
 * 
 * @see org.eclipse.higgins.idas.api.IAttribute
 */
public interface IAttributeModel extends IModel {
	/**
	 * Returns value model of represented type of attribute as it defined in the
	 * context's ontology model.
	 * 
	 * @deprecated Attribute values can all have different value models now
	 */
	public IValueModel getValueModel() throws IdASModelException;

	/**
	 * @return List of value models of attribute as it defined in the context's
	 *         model.
	 */
	public List getValueModels() throws IdASModelException;

	/**
	 * @return List of value models which correspond to ranges directly declared
	 *         for property of attribute in the context's model schema.
	 */
	public List getOwnValueModels() throws IdASModelException;

	/**
	 * @return List of value models which correspond to ranges declared for
	 *         super properties of attribute's property in the context's model
	 *         schema.
	 */
	public List getInheretedValueModels() throws IdASModelException;

	/**
	 * @return <code>true</code> if attribute contains simple values, otherwise
	 *         <code>false</code>
	 */
	public boolean isSimple() throws IdASModelException;

	/**
	 * @return List of {@link org.eclipse.higgins.idas.api.IHasAttributeModel}
	 *         which can have this attribute model
	 */
	public List getOwners() throws IdASModelException;

	/**
	 * @return List of {@link org.eclipse.higgins.idas.api.IAttributeModel}
	 *         which properties are sub properties of property of this attribute
	 *         model
	 */
	public List getSubAttributes() throws IdASModelException;

	/**
	 * @return Attribute model which property is super property for this
	 *         attribute model
	 */
	public IAttributeModel getSuperAttribute() throws IdASModelException;

	/**
	 * property. Indicates that property associated with this attribute has max
	 * cardinality == 1 for all Entities/BlankEntities in the context
	 */
	public static final String SINGLE_VALUED_MODE = "SINGLE_VALUED_MODE";
	/**
	 * Different ontology classes can have different cardinality for the same
	 * property. Indicates that property associated with this attribute has max
	 * cardinality != 1 for all Entities/BlankEntities in the context
	 */
	public static final String MULTY_VALUED_MODE = "MULTY_VALUED_MODE";
	/**
	 * Different ontology classes can have different cardinality for the same
	 * property. Indicates that property associated with this attribute has as
	 * max cardinality == 1 for some Entities/BlankEntities as max cardinality
	 * != 1 for others Entities/BlankEntities
	 */
	public static final String MIXED_MODE = "MIXED_MODE";

	/**
	 * For some context providers the data storage model depends on whether the
	 * attribute is single- or multiple- valued. This method analyzes all
	 * entities in the context model which have this attribute and returns in
	 * which approach is this attribute used
	 * 
	 * @return <code>SINGLE_VALUED_MODEL</code> - if all Entities in the context
	 *         model own this attribute as single valued.
	 *         <code>MULTY_VALUED_MODEL</code> - if all Entities in the context
	 *         model own this attribute as single valued.
	 *         <code>MIXED_MODEL</code> - if some Entities in the context model
	 *         own this attribute as single valued, but others own this
	 *         attribute as multy valued.
	 * @throws IdASException
	 */
	public String getAttributeMode() throws IdASModelException;

}
