/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/
package org.eclipse.higgins.idas.api.model;

import java.net.URL;

/**
 * Represents an information which could be used for visual representation of
 * entity.
 * 
 * @see <a
 *      href="http://www.eclipse.org/higgins/ontologies/2006/display-data">http://www.eclipse.org/higgins/ontologies/6/display-data</a>
 */
public interface IDisplayData {
	/**
	 * Returns display label of entity.
	 * 
	 * @return <code>String</code> containing display label of entity.
	 */
	public String getLabel();

	/**
	 * Returns extended description of the entity.
	 * 
	 * @return <code>String</code> containing extended description of entity
	 *         or <code>null</code> if not available.
	 */
	public String getDescription();

	/**
	 * Returns an {@link URL} of the image which could be used for visual
	 * representation of entity or <code>null</code> if not available.
	 */
	public URL getImage();

	/**
	 * Returns an information on display order of entity which could be used for
	 * visual representation of entity.
	 * 
	 * @return positive <code>int</code> value which represents display order
	 *         of entity or <code>0</code> if not availabe.
	 */
	public int getOrder();
}
