/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *     Jim Sermersheim (Novell) Update to 20070319 interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.net.URI;
import java.util.List;

/**
 * Represents a model of a entity as it defined in the context's ontology model.
 * <p>
 * The type returned by
 * {@link org.eclipse.higgins.idas.api.model.IModel#getType()} could be used in
 * {@link org.eclipse.higgins.idas.api.IContext#addEntity(URI, String)} to
 * create an {@link org.eclipse.higgins.idas.api.IEntity} of the represented
 * type.
 * 
 * @see org.eclipse.higgins.idas.api.IEntity#getModel()
 */
public interface IEntityModel extends IValueModel, IHasAttributeModel {

	/**
	 * @return
	 */
	public List getSubEntityModels() throws IdASModelException;

	/**
	 * @return
	 */
	public IEntityModel getSuperEntityModel() throws IdASModelException;

}
