/*******************************************************************************
 * Copyright (c) 2009 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - Initial cut of interfaces
 *******************************************************************************/
package org.eclipse.higgins.idas.api.model;

import java.net.URI;
import java.util.List;

public interface IHasAttributeModel {

	/**
	 * @return
	 */
	public List getOwnAttributeModels() throws IdASModelException;

	/**
	 * @return
	 */
	public List getInheritedAttributeModels() throws IdASModelException;


	/**
	 * Returns IAttributeModels for the attributes
	 * which are defined (allowed) by this context's model.
	 * @return List of {@link IAttributeModel}
	 */
	public List getAttributeModels() throws IdASModelException;

	/**
	 * Returns IAttributeModel for the specified attribute ID
	 * 
	 * @param attrID the ID of attribute.
	 * @return attribute's model of requested ID or <code>null</code> if
	 *         the specified attrID is not defined or not valid for this
	 *         context's model.
	 */
	public IAttributeModel getAttributeModel(URI attrID) throws IdASModelException;


	/**
	 * @return A positive number indicates the maximum number of values that may 
	 * be present. The value 0 indicates that there is no limit to the number of values that may 
	 * be present. 
	 */
	public int getMaxCardinality(URI attributeType) throws IdASModelException;

	/**
	 * @return 0 if no values are required to be present. This of course also means the 
	 * attribute itself is optional. A positive number indicates the minimum number of values that must 
	 * be present. 
	 */
	public int getMinCardinality(URI attributeType) throws IdASModelException;	
	

}
