/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.util.List;

import org.eclipse.higgins.idas.api.IdASException;

/**
 * Represents value's model of simple attributes as it defined in the context's
 * schema.
 * 
 * @see org.eclipse.higgins.idas.api.ISimpleValue
 * @see <a
 *      href="http://www.eclipse.org/higgins/ontologies/2008/6/higgins#SimpleValue">http://www.eclipse.org/higgins/ontologies/2008/6/higgins#SimpleValue</a>
 */
public interface ISimpleValueModel extends IValueModel {
	
	/**
	 * Determines whether given <code>Object</code> is valid value form of
	 * represented value.
	 * 
	 * @param valueForm
	 *            value to be checked.
	 * @return <code>true</code> if <code>valueForm</code> is valid value
	 *         form and <code>false</code> otherwise.
	 * @throws IdASException 
	 */
	public boolean isValidValue(Object valueForm) throws IdASException;

	/**
	 * Determines whether given <code>String</code> is valid lexical form of
	 * represented value.
	 * 
	 * @param lexicalForm
	 *            value to be checked.
	 * @return <code>true</code> if <code>lexicalForm</code> is valid
	 *         lexical form and <code>false</code> otherwise.
	 * @throws IdASException 
	 */
	public boolean isValid(String lexicalForm) throws IdASException;

	/**
	 * Convert given <code>String</code> to value form of represented value.
	 * 
	 * @param lexicalForm
	 *            <code>String</code> value to be converted.
	 * @return <code>Object</code> which represents valid value form of
	 *         represented value.
	 * @throws IdASModelException
	 *             if given <code>String</code> can't be converted.
	 * @throws IdASException 
	 */
	public Object toValueForm(String lexicalForm) throws IdASException;

	/**
	 * Convert given <code>Object</code> to lexical form of represented value.
	 * 
	 * @param value
	 *            <code>Object</code> value to be converted.
	 * @return <code>String</code> which represents valid lexical form of
	 *         represented value.
	 * @throws IdASModelException
	 *             if given <code>Object</code> can't be converted.
	 * @throws IdASException 
	 */
	public String toLexicalForm(Object value) throws IdASException;

	public boolean isUnique();

	public boolean isOneOf();

	public List getOneOf();

	public String getPattern();

	public int getLength();

	public int getMinLength();

	public int getMaxLength();

	public int getTotalDigits();

	public int getFractionDigits();
	
}
