/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import org.eclipse.higgins.idas.api.IdASException;

/**
 * Represents value's model as it defined in the context's ontology model.
 */
public interface IValueModel extends IModel {

	/**
	 * Determines whether this value model represents simple attribute's value.
	 * 
	 * @return <code>true</code> if represented value is simple and
	 *         <code>false</code> otherwise.
	 * @throws IdASException 
	 */
	public boolean isSimple() throws IdASException;	

}



