/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

/**
 * Thrown when IContext.open() is called on an already open context.
 */
public class ContextOpenException extends IdASException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1135894997143836674L;

	/**
	 * @see IdASException#IdASException()
	 */
	public ContextOpenException() {
		super();
	}

	/**
	 * @param message
	 * @see IdASException#IdASException(String)
	 */
	public ContextOpenException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 * @see IdASException#IdASException(String, Throwable)
	 */
	public ContextOpenException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 * @see IdASException#IdASException(String, Throwable)
	 */
	public ContextOpenException(Throwable cause) {
		super(cause);
	}

}
