/*******************************************************************************
 * Copyright (c) 2006-2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.net.URI;

import org.eclipse.higgins.idas.api.model.IAttributeValueModel;
import org.eclipse.higgins.idas.api.model.IModel;

/**
 * Holds the value of an attribute.<p>
 * This interface is not intended to be instantiated (only used as a super-interface).
 * When the value is a Literal ({@link #isSimple()} returns true), an instance of this interface may be cast to {@link ISimpleAttrValue}, and the table found at {@link ITypedValue#getData()} is used to determine the type returned from {@link ITypedValue#getData()}.    
 * When the value is a Resource ({@link #isSimple()} returns false), an instance of this interface may be cast to {@link IComplexAttrValue}.    
 */
public interface IAttributeValue extends IHasMetadata {
	/**
	 * Value: {@value}
	 */
	public static final String BASE_OWL_URI = "http://www.eclipse.org/higgins/ontologies/2006/higgins#"; 

	/**
	 * @throws IdASException
	 */
	public boolean isSimple() throws IdASException;

	/**
	 * Returns this value's data type (like string, int, address)
	 * TODO (Doc): refer to an example like those found at <a href="http://wiki.eclipse.org/index.php/Person-with-address_Example_Context_Ontology">http://wiki.eclipse.org/index.php/Person-with-address_Example_Context_Ontology</a>
	 * @return The OWL type for this attribute's value (i.e. http://www.w3.org/2001/XMLSchema/string or http://www.eclipse.org/higgins/ontologies/2006/higgins#NodeRelation).
	 * @throws IdASException
	 * @deprecated Instead, call {@link IAttributeValue#getModel()} and from that call {@link IModel#getType()}.  
	 * Doing this is equivalent to calling this method.
	 */
	public URI getDataType() throws IdASException; 

	/**
	 * Removes this value from its IAttribute container
	 * Note: This operation is only applied to any backing data store after
	 * IContext.applyUpdates() is called.
	 * @throws {@link IdASException}
	 */
	public void remove() throws IdASException;
	
	/**
	 * returns true if this IAttributeValue is equal to the passed IAttributeValue
	 * This should test the attribute ID, metadata, and the value for equality.
	 */
	public boolean equals(IAttributeValue value) throws IdASException;

	/**
	 * Returns the model for this type of attribute value as it is 
	 * defined in the context's schema. 
	 *  
	 * @return the model for this attribute value
	 * @throws IdASException
	 */
	public IAttributeValueModel getModel() throws IdASException;
}
