/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interfaces agreed upon 20060707
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.net.URI;
import java.util.Iterator;

/**
 * Represents a relationship to another {@link IContext}.<p>
 * TODO (Doc): add javadoc to methods. 
 *
 */
public interface IContextRelation extends IHasMetadata {

	/**
	 * Adds the specified context ID as a related context 
	 * Note: This operation is only applied to any backing data 
	 * store after {@link IContext#applyUpdates()} is called.
	 * @param contextID the context ID of the specified related context to be added
	 */
	public void addRelatedContext(URI contextID) throws IdASException;

	/**
	 * Removes the specified context ID as a related context 
	 * Note: This operation is only applied to any backing data 
	 * store after {@link IContext#applyUpdates()} is called.
	 * @param contextID the context ID of the specified related context to be removed
	 */
	public void removeRelatedContext(URI contextID) throws IdASException;

	/**
	 * Removes this entire IContextRelation from its containing IContext
	 * Note: This operation is only applied to any backing data store after
	 * {@link IContext#applyUpdates()} is called.
	 * @throws {@link IdASException}
	 */
	public void remove();
	
	/**
	 * Returns this relationship's type.<p>
	 * TODO (Doc): Add (or point at) doc which explains relationship types.
	 * TODO (Doc): Add example types. Possibly some that denote hierarchy (parent, child, sibling). 
	 * @return A {@link URI} representing this relationship's type.
	 * @throws IdASException
	 */
	public URI getType() throws IdASException;
	
	/**
	 * 
	 * @return Iterator of {@link URI}. Each representing a related context ID
	 * @throws IdASException
	 */
	public Iterator getRelatedObjects() throws IdASException;
}
