/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interfaces agreed upon 2006
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import org.eclipse.higgins.idas.api.IdASException;

/**
 * A filter is either an assertion, or an operator plus a set of filters.<p>
 * For example, the filter ((a=b) && (c=d)) || (e=f) would be constructed as follows:<br>
 * - Build three IFilterAssertions, one each for a=b, c=d, and e=f<br>
 * - Build three IFilters, each containing one of the three IFilterAssertions<br>
 * - Build an IFilter containing the && operator and the first previous IFilters (a=b and c=d)<br>
 * - Build the final IFilter containing the || operator the previous filter, and the e=f filter<p>
 * 
 * TODO (Doc): Add rules for UNDEFINED state.
 *
 */
public interface IFilter {
	 /**
	 * When set as the operator, the filter is TRUE when all IFilters are TRUE, otherwise FALSE.<p>
	 * At least two IFilters are required to be added via {@link #addFilter(IFilter)}
	 * Value: {@value}
	 */
	public static final String OP_AND = "urn:eclipse.higgins.idas.OP_AND"; 

	/**
	 * When set as the operator, the filter is TRUE when any IFilter is TRUE, otherwise FALSE.<p>
	 * At least two IFilters are required to be added via {@link #addFilter(IFilter)}
	 * Value: {@value}
	 */
	public static final String OP_OR = "urn:eclipse.higgins.idas.OP_OR"; 

	/**
	 * When set as the operator, the filter is TRUE when the IFilter is FALSE, FALSE when the IFilter is TRUE.<p>
	 * Exactly one IFilter is required to be added via {@link #addFilter(IFilter)}
	 * Value: {@value}
	 */
	public static final String OP_NOT = "urn:eclipse.higgins.idas.OP_NOT"; 

	/**
	 * When this is called, {@link #addFilter(IFilter)} and {@link #setOperator(String)} may not be called.  
	 */
	public void setAssertion(IFilterAssertion assertion) throws IdASException;
	
	/**
	 * @param operator a logical operator (one of {@link #OP_AND}, {@link #OP_OR}, or {@link #OP_NOT})
	 */
	public void setOperator(String operator) throws IdASException;
	
	/**
	 * Adds a filter to the set of filters. The number of filters added depends on the operator. See {@link #OP_AND}, {@link #OP_OR}, and {@link #OP_NOT}
	 */
	public void addFilter(IFilter filter) throws IdASException;
	
	/**
	 * Adds a filter containing the passed IFilterAssertion. 
	 */
	public void addFilter(IFilterAssertion filterAssertion) throws IdASException;
	
}
