/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

/**
 * Represents a filter assertion about metadata.<br> 
 * This assertion is made up of a comparator (operator), metadataID and assertion value.<p>
 *  
// * The particular type and form of the IMetadata used as an assertion is dictated by the comparator and the metadata type.
// * In other words, a particular attribute type will specify the comparators valid for that type, as well as the format of assertion value for each valid comparator.
 * TODO (Doc): Refer to example specifications for this
 */
public abstract interface IFilterMetadataAssertion extends IFilterAssertion {
	/**
	 * Compares true when the specified metadata type is present in a tested container of metadata.<p>
	 * An assertion value is not specified.<P>
	 * Value: {@value}
	 */
	public static final String COMP_META_PRESENT = "urn:org.eclipse.higgins.idas.api.comparator.metadata.present";

	/**
	 * Compares true when a tested Node has a metadata of the specified type which contains a value equal to the specified assertion value.<P> 
	 * Value: {@value}
	 */
	public static final String COMP_META_EQ = "urn:org.eclipse.higgins.idas.api.comparator.metadata.equality";

	/**
	 * Compares true when a tested Node has a metadata of the specified type which contains a value greater or equal to the specified assertion value.<P> 
	 * Value: {@value}
	 */
	public static final String COMP_PROP_GE = "urn:org.eclipse.higgins.idas.api.comparator.metadata.greaterOrEqual";

	/**
	 * Compares true when a tested Node has a metadata of the specified type which contains a value less or equal to the specified assertion value.<P>
	 * Value: {@value}
	 */
	public static final String COMP_PROP_LE = "urn:org.eclipse.higgins.idas.api.comparator.metadata.lessOrEqual";

	/**
	 * Compares true when a tested Node has a metadata of the specified type which contains a value containing the substring specified by the assertion value.<P>
	 * TODO: need to handle initial, any, final substrings. 
	 * Value: {@value}
	 */
	public static final String COMP_PROP_SUBSTR = "urn:org.eclipse.higgins.idas.api.comparator.metadata.substring";

	/**
	 * Specifies the assertion data to be tested against values of a metadata container's metadata.
	 * 
	 */
	public void setAssertionValue(IMetadata assertion) throws IdASException;

}