/*******************************************************************************
 * Copyright (c) 2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

/**
 * Thrown when a specified Type is invalid.
 */
public class InvalidNodeIDException extends IdASException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2061692182356732973L;

	/**
	 * @see IdASException#IdASException()
	 */
	public InvalidNodeIDException() {
		super();
	}

	/**
	 * @param message
	 * @see IdASException#IdASException(String)
	 */
	public InvalidNodeIDException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 * @see IdASException#IdASException(String, Throwable)
	 */
	public InvalidNodeIDException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 * @see IdASException#IdASException(Throwable)
	 */
	public InvalidNodeIDException(Throwable cause) {
		super(cause);
	}

}
