/*******************************************************************************
 * Copyright (c) 2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

/**
 * Thrown in cases where a value is being added to an attribute and that value
 * already exists. Depending on the context provider, this may happen as values
 * are being added or may happen when {@link IContext#applyUpdates()} is called.
 * No two {@link IAttributeValue}s held by a single {@link IAttribute) are allowed
 * to be the same (as defined by the attribute's equality matching rules.  
 */
public class ValueAlreadyExistsException extends IdASException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 222210684973286079L;

	/**
	 * @see IdASException#IdASException()
	 */
	public ValueAlreadyExistsException() {
		super();
	}

	/**
	 * @param message
	 * @see IdASException#IdASException(String)
	 */
	public ValueAlreadyExistsException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 * @see IdASException#IdASException(String, Throwable)
	 */
	public ValueAlreadyExistsException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 * @see IdASException#IdASException(Throwable)
	 */
	public ValueAlreadyExistsException(Throwable cause) {
		super(cause);
	}

}
