/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.net.URI;
import java.util.Iterator;

/**
 * Represents a model of value for complex attributes as it defined in the
 * context's ontology model.
 * 
 * @see org.eclipse.higgins.idas.api.IComplexAttrValue
 * @see <a
 *      href="http://www.eclipse.org/higgins/ontologies/2006/higgins#ComplexValue">http://www.eclipse.org/higgins/ontologies/2006/higgins#ComplexValue</a>
 */
public interface IAttributeComplexValueModel extends IAttributeValueModel {

	/**
	 * Returns list of sub-attributes in represented complex attribute as it
	 * defined in the context's ontology model.
	 * @return Iterator of {@link IAttributeModel}s
	 */
	public Iterator getAttributes();

	/**
	 * Returns attribute's model of requested type.
	 * 
	 * @param attrID
	 *            the type of attribute.
	 * @return attribute's model of requested type or <code>null</code> if
	 *         requested type of attributes is not defined in the context's
	 *         schema for represented type of complex attributes.
	 */
	public IAttributeModel getAttribute(URI attrID);
}
