/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.net.URI;
import java.util.Iterator;


/**
 * Represents value's model of attributes as it defined in the context's ontology model.
 */
public interface IAttributeValueModel extends IModel {
	/**
	 * Returns XSD datatype of represented value as it defined in the context's
	 * schema. Please note that XSD:ENTITY, XSD:ID and XSD:IDREF are not
	 * currently supported by context's ontology models.
	 * 
	 * @return <code>URI</code> of value's datatype.
	 * @see <a href="http://www.w3.org/2001/XMLSchema#">XML Schema</a>
	 */
	public URI getType();

	/**
	 * Returns non negative integer value which represents maximum cardinality
	 * of represented attribute's value or <code>-1</code> if not defined.
	 * 
	 * @see #getMaxCardinality()
	 * @deprecated This has been moved to IAttributeModel
	 */
	public int getMaxCardinality();

	/**
	 * Returns non negative integer value which represents minimum cardinality
	 * of represented attribute's value or <code>-1</code> if not defined.
	 * 
	 * @see #getMinCardinality()
	 * @deprecated This has been moved to IAttributeModel
	 */
	public int getMinCardinality();

	/**
	 * Determines whether this value model represents simple attribute's value.
	 * 
	 * @return <code>true</code> if represented value is simple and
	 *         <code>false</code> otherwise.
	 */
	public boolean isSimple();
	
	/**
	 * Returns IMetadataModels for the metadata elements
	 * which are defined (allowed) in this attribute value model.
	 * @return Iterator of {@link IMetadataModel}
	 */
	public Iterator getMetadataModels(); 
	
	/**
	 * Returns IMetadataModel for the specified metadata ID
	 * 
	 * @param metadataType the type of metadata.
	 * @return metadata's model of requested type or <code>null</code> if
	 *         the specified metadataID is not defined or not valid for this
	 *         attribute value model.
	 */
	public IMetadataModel getMetadataModel(URI metadataType);	

}



