/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/
package org.eclipse.higgins.idas.api.model;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IFilter;

// <p>
// To retrieve this representation of the context model
// {@link org.eclipse.higgins.idas.api.IContext#getContextModel()} could be used.
/**
 * Represents a model of the context object as it defined in the context's ontology model.
 * Since context's ontology model is defined in OWL DL format this interface is designed
 * to simlify query and interpretation of the context's ontology model.
 * <p>
 * The {@link java.net.URI URI} returned by
 * {@link IModel#getType()} could be used to retrieve
 * an {@link java.net.URL URL} of the OWL ontology where this context's model is
 * defined.
 * 
 * @see org.eclipse.higgins.idas.api.IContext IContext
 */
public interface IContextModel extends IModel {

	/**
	 * Generic method to query context model for any kind of element matching the 
	 * specified <code>type</code>.  This could be the type of a node,
	 * attribute, metadata, etc.
	 * 
	 * @param type the type of the node for which to retrieve the model.
	 * @return the model of the element specified by <code>type</code>
	 * or <code>null</code> if no element corresponding to that type is defined 
	 * in this context model.
	 */
	public IModel getModel(URI type);

	/**
	 * Returns {@link INodeModel}s for the nodes 
	 * which are defined (allowed) in this context model.
	 * @return Iterator of {@link INodeModel}
	 * @see org.eclipse.higgins.idas.api.IContext#getNode(String)
	 * @see org.eclipse.higgins.idas.api.IContext#getNodes(IFilter)
	 */
	public Iterator getNodeModels();
	
	/**
	 * Returns the INodeModel for the specified node type
	 * @param nodeType
	 * @return {@link INodeModel} for the specified node type 
	 */	
	public INodeModel getNodeModel(URI nodeType);
}
