/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/
package org.eclipse.higgins.idas.api.model;

import java.net.URI;

/**
 * Base interface to represent model information of elements defined in the
 * context's ontology model. Context's schema is defined in OWL DL format and
 * {@link org.eclipse.higgins.idas.api.model "Model API"} is designed to simplify
 * access to schema's information.
 */
public interface IModel {
	/**
	 * Returns the type of element that this model represents.
	 * 
	 * @return {@link URI} of the model definition.
	 */
	public URI getType();

	/**
	 * Returns display data information for this model.
	 * 
	 * @return display data of represented node or <code>null</code> if not
	 *         available.
	 * @see <a
	 *      href="http://www.eclipse.org/higgins/ontologies/2006/display-data#displayData">http://www.eclipse.org/higgins/ontologies/2006/display-data#displayData</a>
	 */
	public IDisplayData getDisplayData();
}
